<?php
session_start();
require '../../edu_digital/config/database.php';

/* ================= CEK LOGIN ================= */
if (!isset($_SESSION['login']) || $_SESSION['user']['role'] != 'admin') {
    header("Location: ../../edu_digital/auth/login.php");
    exit;
}

/* ================= HELPER ================= */
function rupiah($angka){
    return "Rp " . number_format((float)$angka,0,',','.');
}

/* ================= AMBIL DATA KELAS ================= */
$kelas_query = $conn->query("
    SELECT k.id,
           k.nama_kelas,
           p.nama AS nama_paket,
           CONCAT(k.nama_kelas,'-',IFNULL(p.nama,'')) AS kelas_full
    FROM kelas k
    LEFT JOIN paket p ON p.id = k.paket_id
    ORDER BY k.nama_kelas ASC, p.nama ASC
");

/* ================= INISIALISASI ================= */
$kelas_id  = isset($_GET['kelas_id']) ? (int)$_GET['kelas_id'] : 0;
$siswa_id  = isset($_GET['siswa_id']) ? (int)$_GET['siswa_id'] : 0;

$siswa = [];
$tagihan = [];
$riwayat = [];
$selected_siswa = null;
$total_tunggakan_nominal = 0;

/* ================= AMBIL SISWA ================= */
if ($kelas_id > 0) {
    $stmt = $conn->prepare("
        SELECT id, nama 
        FROM siswa 
        WHERE kelas_id=? 
        ORDER BY nama ASC
    ");
    $stmt->bind_param("i",$kelas_id);
    $stmt->execute();
    $result = $stmt->get_result();
    while($row = $result->fetch_assoc()){
        $siswa[] = $row;
    }
}

/* ================= AMBIL DATA SISWA & TAGIHAN ================= */
if ($siswa_id > 0) {

    // Data siswa
    $stmt = $conn->prepare("SELECT * FROM siswa WHERE id=?");
    $stmt->bind_param("i",$siswa_id);
    $stmt->execute();
    $selected_siswa = $stmt->get_result()->fetch_assoc();

    if($selected_siswa){

        // Ambil tagihan + total bayar (support cicilan)
        $stmt = $conn->prepare("
            SELECT 
                t.*,
                COALESCE(SUM(p.jumlah_bayar),0) as total_bayar
            FROM spp_tagihan t
            LEFT JOIN spp_pembayaran p 
                ON p.tagihan_id = t.id
            WHERE t.siswa_id=?
            GROUP BY t.id
            ORDER BY t.id ASC
        ");
        $stmt->bind_param("i",$siswa_id);
        $stmt->execute();
        $result = $stmt->get_result();

        while($row = $result->fetch_assoc()){
            $row['sisa'] = $row['nominal'] - $row['total_bayar'];
            if($row['sisa'] > 0){
                $total_tunggakan_nominal += $row['sisa'];
            }
            $tagihan[] = $row;
        }

        // Riwayat pembayaran
        $stmt = $conn->prepare("
            SELECT * FROM spp_pembayaran
            WHERE siswa_id=?
            ORDER BY tanggal_bayar DESC
        ");
        $stmt->bind_param("i",$siswa_id);
        $stmt->execute();
        $result = $stmt->get_result();
        while($row = $result->fetch_assoc()){
            $riwayat[] = $row;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Input Pembayaran SPP</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
    background:linear-gradient(135deg,#e3f2fd,#fce4ec);
    padding-top:80px;
    padding-bottom:90px;
}
.card-custom{
    border-radius:20px;
}
</style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark bg-primary shadow-sm fixed-top">
<div class="container">
<span class="navbar-brand fw-semibold">
<i class="bi bi-cash-coin"></i> SPP Admin
</span>
<div class="ms-auto text-white small">
<?= htmlspecialchars($_SESSION['user']['nama']); ?>
</div>
</div>
</nav>

<div class="container py-5">
<div class="card shadow-lg border-0 card-custom">
<div class="card-body p-4">

<h4 class="mb-4">
<i class="bi bi-credit-card"></i> Input Pembayaran SPP
</h4>

<form method="GET" class="row g-3 mb-4">

<div class="col-md-4">
<label class="form-label">Pilih Kelas</label>
<select name="kelas_id" class="form-select" onchange="this.form.submit()">
<option value="">-- Pilih Kelas --</option>
<?php while($k = $kelas_query->fetch_assoc()): 
$label = rtrim($k['kelas_full'],'-'); ?>
<option value="<?= $k['id']; ?>" <?= ($kelas_id==$k['id'])?'selected':'' ?>>
<?= htmlspecialchars($label); ?>
</option>
<?php endwhile; ?>
</select>
</div>

<?php if(count($siswa) > 0): ?>
<div class="col-md-4">
<label class="form-label">Pilih Siswa</label>
<select name="siswa_id" class="form-select" onchange="this.form.submit()">
<option value="">-- Pilih Siswa --</option>
<?php foreach($siswa as $s): ?>
<option value="<?= $s['id']; ?>" <?= ($siswa_id==$s['id'])?'selected':'' ?>>
<?= htmlspecialchars($s['nama']); ?>
</option>
<?php endforeach; ?>
</select>
</div>
<?php endif; ?>

</form>

<?php if($selected_siswa): ?>

<div class="alert alert-info">
<strong><?= htmlspecialchars($selected_siswa['nama']); ?></strong><br>
Total Tunggakan: <strong><?= rupiah($total_tunggakan_nominal); ?></strong>
</div>

<h5>Daftar Tagihan</h5>

<table class="table table-bordered mt-3">
<thead class="table-light">
<tr>
<th>Bulan</th>
<th>Nominal</th>
<th>Sudah Bayar</th>
<th>Sisa</th>
<th width="250">Aksi</th>
</tr>
</thead>
<tbody>

<?php foreach($tagihan as $t): ?>
<tr>
<td><?= htmlspecialchars($t['bulan']); ?></td>
<td><?= rupiah($t['nominal']); ?></td>
<td><?= rupiah($t['total_bayar']); ?></td>
<td class="<?= $t['sisa']>0?'text-danger':'text-success' ?>">
<strong><?= rupiah($t['sisa']); ?></strong>
</td>
<td>

<?php if($t['sisa'] > 0): ?>
<form action="../proses/simpan_pembayaran.php" method="POST">
<input type="hidden" name="tagihan_id" value="<?= $t['id']; ?>">
<input type="hidden" name="siswa_id" value="<?= $t['siswa_id']; ?>">

<input type="number"
name="jumlah_bayar"
class="form-control form-control-sm mb-2"
max="<?= $t['sisa']; ?>"
placeholder="Maks: <?= $t['sisa']; ?>"
required>

<select name="metode" class="form-select form-select-sm mb-2" required>
<option value="">Metode</option>
<option value="cash">Cash</option>
<option value="transfer">Transfer</option>
<option value="qris">QRIS</option>
</select>

<button class="btn btn-success btn-sm w-100">
<i class="bi bi-check-circle"></i> Bayar
</button>
</form>
<?php else: ?>
<span class="badge bg-success">Lunas</span>
<?php endif; ?>

</td>
</tr>
<?php endforeach; ?>

</tbody>
</table>

<h5 class="mt-5">Riwayat Pembayaran</h5>

<?php if(count($riwayat) > 0): ?>
<table class="table table-striped mt-3">
<tr>
<th>Tanggal</th>
<th>Metode</th>
<th>Jumlah</th>
</tr>
<?php foreach($riwayat as $r): ?>
<tr>
<td><?= htmlspecialchars($r['tanggal_bayar']); ?></td>
<td><?= ucfirst($r['metode']); ?></td>
<td><?= rupiah($r['jumlah_bayar']); ?></td>
</tr>
<?php endforeach; ?>
</table>
<?php else: ?>
<div class="alert alert-warning mt-3">
Belum ada riwayat pembayaran.
</div>
<?php endif; ?>

<?php endif; ?>

</div>
</div>
</div>

</body>
</html>
