<?php
require __DIR__ . '/auth.php';
require __DIR__ . '/../config/database.php';

if (empty($_SESSION['login_siswa'])) {
    header("Location: ../auth/login_siswa.php");
    exit;
}

$id_ujian = (int)($_GET['id'] ?? 0);
$id_siswa = $_SESSION['siswa']['id'];

/* =============================
   CEK UJIAN + PAKET AKTIF
============================= */
$q = mysqli_query(
    $conn,
    "SELECT u.id, u.nama_ujian, u.durasi, u.id_paket
     FROM ujian u
     JOIN paket_ujian p ON p.id = u.id_paket
     WHERE u.id = $id_ujian
       AND u.status = 'aktif'
       AND p.status = 'Aktif'
     LIMIT 1"
);

if (mysqli_num_rows($q) !== 1) {
    die("Ujian tidak valid atau paket tidak aktif");
}

$ujian = mysqli_fetch_assoc($q);

/* =============================
   AMBIL TOKEN SESUAI PAKET
============================= */
$stmt = mysqli_prepare(
    $conn,
    "SELECT token
     FROM token
     WHERE aktif='Y'
       AND id_paket=?
     ORDER BY id DESC
     LIMIT 1"
);
mysqli_stmt_bind_param($stmt, "i", $ujian['id_paket']);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);
$t   = mysqli_fetch_assoc($res);
$token_db = $t['token'] ?? null;

$error = null;

/* =============================
   PROSES TOKEN
============================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $token_input = strtoupper(trim($_POST['token'] ?? ''));

    if (!$token_input) {
        $error = "Token wajib diisi";
    }
    elseif (!$token_db) {
        $error = "Token belum tersedia untuk paket ini";
    }
    elseif ($token_input !== strtoupper($token_db)) {
        $error = "Token salah!";
    }
    else {

        /* =============================
           SIMPAN SESSION UJIAN
        ============================= */
        session_regenerate_id(true);

        $_SESSION['ujian'] = [
            'id_ujian' => $ujian['id'],
            'id_paket' => $ujian['id_paket'],
            'mulai'    => time(),
            'durasi'   => (int)$ujian['durasi']
        ];

        header("Location: mulai.php");
        exit;
    }
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Verifikasi Token</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#f4f6f9}
.card{border-radius:18px}
</style>
</head>
<body>

<div class="container py-5">
<div class="row justify-content-center">
<div class="col-md-4">

<div class="card shadow">
<div class="card-body">

<h5 class="fw-bold text-center mb-2">🔐 VERIFIKASI TOKEN</h5>
<p class="text-muted text-center mb-3">
<?= htmlspecialchars($ujian['nama_ujian']) ?>
</p>

<?php if ($error): ?>
<div class="alert alert-danger text-center">
<?= htmlspecialchars($error) ?>
</div>
<?php endif ?>

<form method="post">
<input type="text"
       name="token"
       class="form-control text-center fw-bold mb-3"
       placeholder="MASUKKAN TOKEN"
       maxlength="6"
       autofocus
       required>

<button class="btn btn-primary w-100">
▶ MASUK UJIAN
</button>
</form>

</div>
</div>

</div>
</div>
</div>

</body>
</html>
