<?php
session_start();
require __DIR__ . '/../config/database.php';

/* CEK LOGIN */
if (empty($_SESSION['login_siswa']) || empty($_SESSION['siswa'])) {
    header("Location: login_siswa.php");
    exit;
}

/* AMBIL TOKEN */
$token = strtoupper(trim($_POST['token'] ?? ''));

if ($token === '') {
    $_SESSION['error'] = "Token ujian wajib diisi!";
    header("Location: biodata_siswa.php");
    exit;
}

/* VALIDASI TOKEN */
$stmt = mysqli_prepare(
    $conn,
    "SELECT token FROM token WHERE token=? AND aktif='Y' LIMIT 1"
);
mysqli_stmt_bind_param($stmt, "s", $token);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);

if (mysqli_num_rows($res) !== 1) {
    $_SESSION['error'] = "Token ujian tidak valid!";
    header("Location: biodata_siswa.php");
    exit;
}

/* AMBIL UJIAN AKTIF */
$ujian = mysqli_fetch_assoc(
    mysqli_query($conn,"
        SELECT id, durasi 
        FROM ujian 
        WHERE aktif='Y' 
        LIMIT 1
    ")
);

if (!$ujian) {
    $_SESSION['error'] = "Ujian belum tersedia!";
    header("Location: biodata_siswa.php");
    exit;
}

/* SET SESSION UJIAN */
session_regenerate_id(true);
$_SESSION['ujian_id'] = $ujian['id'];
$_SESSION['mulai']    = time();

/* MASUK UJIAN */
header("Location: ujian.php");
exit;
