<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require __DIR__ . '/../config/database.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/* ================= PROTEKSI ================= */
if (
    empty($_SESSION['login_siswa']) ||
    empty($_SESSION['siswa']['id'])
) {
    header("Location: ../auth/login_siswa.php");
    exit;
}

$id_siswa    = (int)$_SESSION['siswa']['id'];
$id_ujian    = (int)($_POST['id_ujian'] ?? 0);
$token_input = strtoupper(trim($_POST['token'] ?? ''));

if ($id_ujian === 0 || $token_input === '') {
    $_SESSION['error'] = "Token ujian wajib diisi!";
    header("Location: biodata_siswa.php");
    exit;
}

/* ================= AMBIL DATA UJIAN + TOKEN ================= */
$stmt = mysqli_prepare($conn,"
    SELECT 
        u.id,
        u.durasi,
        t.token
    FROM ujian u
    LEFT JOIN token t 
        ON t.id_ujian = u.id AND t.aktif='Y'
    WHERE u.id=? AND u.status='Aktif'
    LIMIT 1
");

if(!$stmt){
    die("Prepare error: ".mysqli_error($conn));
}

mysqli_stmt_bind_param($stmt,"i",$id_ujian);
mysqli_stmt_execute($stmt);
$res = mysqli_stmt_get_result($stmt);

$ujian = ($res && mysqli_num_rows($res)) ? mysqli_fetch_assoc($res) : null;
mysqli_stmt_close($stmt);

if (!$ujian) {
    $_SESSION['error'] = "Ujian tidak ditemukan atau belum aktif!";
    header("Location: biodata_siswa.php");
    exit;
}

if (empty($ujian['token'])) {
    $_SESSION['error'] = "Token ujian belum dibuat!";
    header("Location: biodata_siswa.php");
    exit;
}

if ($token_input !== strtoupper($ujian['token'])) {
    $_SESSION['error'] = "Token salah!";
    header("Location: biodata_siswa.php");
    exit;
}

/* ================= SIMPAN SESSION UJIAN ================= */
$_SESSION['ujian'] = [
    'id_ujian' => (int)$ujian['id'],
    'mulai'    => time(),
    'durasi'   => (int)$ujian['durasi']
];

/* ================= CATAT STATUS LOGIN ================= */
mysqli_query($conn,"
    INSERT INTO login_siswa (id_siswa,id_ujian,status,login_time,last_active)
    VALUES ($id_siswa, {$ujian['id']}, 'mengerjakan', NOW(), NOW())
    ON DUPLICATE KEY UPDATE
        status='mengerjakan',
        last_active=NOW()
");


/* ================= REDIRECT ================= */
header("Location: ujian.php");
exit;
