<?php
require 'step.php';

/* =============================
   PROTEKSI STEP (TANPA LOCK)
============================== */
if (!isset($_SESSION['step']) || $_SESSION['step'] < 3) {
  header("Location: admin.php");
  exit;
}

/* =============================
   PROSES SUBMIT
============================== */
if (isset($_POST['finish'])) {

  $db = $_SESSION['db'];
  $conn = mysqli_connect($db['host'], $db['user'], $db['pass'], $db['db']);
  if (!$conn) die('Koneksi database gagal');

  /* =============================
     BUAT TABEL
  ============================== */
  mysqli_query($conn,"
  CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama VARCHAR(100),
    username VARCHAR(50),
    password VARCHAR(255),
    role VARCHAR(20)
  )");

  mysqli_query($conn,"
  CREATE TABLE IF NOT EXISTS sekolah (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama_aplikasi VARCHAR(100),
    nama_sekolah VARCHAR(150),
    alamat TEXT,
    npsn VARCHAR(20),
    telp VARCHAR(20),
    kepala_sekolah VARCHAR(100),
    logo VARCHAR(100)
  )");

  /* =============================
     UPLOAD LOGO
  ============================== */
  $logo = '';
  if (!empty($_FILES['logo']['name'])) {
    $dir = '../assets/logo/';
    if (!is_dir($dir)) mkdir($dir, 0777, true);

    $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
    $logo = 'logo_' . time() . '.' . $ext;

    move_uploaded_file($_FILES['logo']['tmp_name'], $dir . $logo);
  }

  /* =============================
     INSERT ADMIN
  ============================== */
  $a = $_SESSION['admin'];
  mysqli_query($conn,"
  INSERT INTO users (nama, username, password, role)
  VALUES ('$a[nama]', '$a[user]', '$a[pass]', 'admin')
  ");

  /* =============================
     INSERT SEKOLAH
  ============================== */
  mysqli_query($conn,"
  INSERT INTO sekolah
  (nama_aplikasi, nama_sekolah, alamat, npsn, telp, kepala_sekolah, logo)
  VALUES (
    '$_POST[nama_aplikasi]',
    '$_POST[nama]',
    '$_POST[alamat]',
    '$_POST[npsn]',
    '$_POST[telp]',
    '$_POST[kepsek]',
    '$logo'
  )
  ");

  /* =============================
     SIMPAN CONFIG DATABASE
  ============================== */
  if (!is_dir('../config')) mkdir('../config', 0777, true);

  file_put_contents('../config/database.php',
"<?php
\$conn = mysqli_connect('$db[host]', '$db[user]', '$db[pass]', '$db[db]');
if (!\$conn) {
  die('Koneksi database gagal');
}
");

  /* =============================
     LOCK INSTALLER (FINAL)
  ============================== */
  file_put_contents('../install.lock', date('Y-m-d H:i:s'));

  $_SESSION['step'] = 4;
  header("Location: selesai.php");
  exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Instalasi Sekolah</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{background:#f4f6f9}
.card{border-radius:14px}
.stepper{display:flex;justify-content:space-between;position:relative;margin-bottom:30px}
.stepper::before{content:'';position:absolute;top:12px;left:0;right:0;height:2px;background:#e0e0e0}
.step{text-align:center;width:100%;position:relative}
.step span{width:24px;height:24px;border-radius:50%;display:inline-flex;align-items:center;justify-content:center;background:#20c997;color:#fff;font-size:13px}
.step.inactive span{background:#ced4da}
.step label{display:block;font-size:13px;margin-top:6px}
.footer{font-size:12px;color:#6c757d}
</style>
</head>

<body>
<div class="container mt-5">
  <div class="card shadow-sm p-4">

    <h5 class="text-center mb-4">Instalasi Aplikasi</h5>

    <!-- STEPPER -->
    <div class="stepper">
      <div class="step"><span>✓</span><label>Database</label></div>
      <div class="step"><span>✓</span><label>Administrator</label></div>
      <div class="step"><span>3</span><label>Sekolah</label></div>
      <div class="step inactive"><span>4</span><label>Selesai</label></div>
    </div>

    <!-- FORM -->
    <form method="post" enctype="multipart/form-data">
      <div class="row g-3">

        <div class="col-md-12">
          <label class="form-label fw-semibold">Nama Aplikasi *</label>
          <input type="text" name="nama_aplikasi" class="form-control" required>
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Nama Sekolah *</label>
          <input type="text" name="nama" class="form-control" required>
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">NPSN *</label>
          <input type="text" name="npsn" class="form-control" required>
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Kepala Sekolah *</label>
          <input type="text" name="kepsek" class="form-control" required>
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Nomor Telepon</label>
          <input type="text" name="telp" class="form-control">
        </div>

        <div class="col-md-12">
          <label class="form-label fw-semibold">Alamat *</label>
          <textarea name="alamat" class="form-control" rows="3" required></textarea>
        </div>

        <div class="col-md-6">
          <label class="form-label fw-semibold">Logo Sekolah</label>
          <input type="file" name="logo" class="form-control" accept="image/*">
        </div>

      </div>

      <div class="d-flex justify-content-between mt-4">
        <a href="admin.php" class="btn btn-outline-secondary">← Sebelumnya</a>
        <button type="submit" name="finish" class="btn btn-success px-5">
          ✓ Selesaikan Instalasi
        </button>
      </div>

      <div class="text-center footer mt-4">
        Dikembangkan oleh <b>Bang Zae</b>
      </div>
    </form>

  </div>
</div>
</body>
</html>
