-- Dump SQL Lengkap Smart_CBT (Tanpa Tabel Siswa)
-- Database: smart_cbt
-- Ready-to-import

CREATE DATABASE IF NOT EXISTS `smart_cbt` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE `smart_cbt`;

-- =======================================
-- Table structure for table `acak_opsi`
-- =======================================
DROP TABLE IF EXISTS `acak_opsi`;
CREATE TABLE `acak_opsi` (
  `id_siswa` INT(11) NOT NULL,
  `id_soal` INT(11) NOT NULL,
  `huruf_tampil` CHAR(1) NOT NULL,
  `huruf_asli` CHAR(1) NOT NULL,
  PRIMARY KEY (`id_siswa`,`id_soal`,`huruf_tampil`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =======================================
-- Table structure for table `hasil`
-- =======================================
DROP TABLE IF EXISTS `hasil`;
CREATE TABLE `hasil` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `id_siswa` INT(11) NOT NULL,
  `id_ujian` INT(11) NOT NULL,
  `nilai` INT(11) NOT NULL DEFAULT 0,
  `selesai` DATETIME DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unik_siswa_ujian` (`id_siswa`,`id_ujian`),
  KEY `id_siswa` (`id_siswa`),
  KEY `id_ujian` (`id_ujian`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =======================================
-- Table structure for table `jawaban`
-- =======================================
DROP TABLE IF EXISTS `jawaban`;
CREATE TABLE `jawaban` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `id_ujian` INT(11) NOT NULL,
  `id_siswa` INT(11) NOT NULL,
  `id_soal` INT(11) NOT NULL,
  `tipe` ENUM('pg','essay') NOT NULL,
  `jawaban_pg` CHAR(1) DEFAULT NULL,
  `jawaban_essay` TEXT DEFAULT NULL,
  `nilai` INT(11) DEFAULT NULL,
  `dibuat` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `unik_jawaban` (`id_siswa`,`id_soal`),
  KEY `id_ujian` (`id_ujian`),
  KEY `id_soal` (`id_soal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =======================================
-- Table structure for table `login_siswa`
-- =======================================
DROP TABLE IF EXISTS `login_siswa`;
CREATE TABLE `login_siswa` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `id_siswa` INT(11) NOT NULL,
  `id_ujian` INT(11) NOT NULL,
  `status` ENUM('login','mengerjakan','selesai') DEFAULT 'login',
  `last_active` DATETIME DEFAULT NULL,
  `login_time` DATETIME DEFAULT CURRENT_TIMESTAMP(),
  `logout_time` DATETIME DEFAULT NULL,
  `force_logout` TINYINT(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniq_siswa_ujian` (`id_siswa`,`id_ujian`),
  KEY `idx_last_active` (`last_active`),
  KEY `idx_status` (`status`),
  KEY `fk_login_siswa_ujian` (`id_ujian`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =======================================
-- Table structure for table `pelanggaran_ujian`
-- =======================================
DROP TABLE IF EXISTS `pelanggaran_ujian`;
CREATE TABLE `pelanggaran_ujian` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `id_siswa` INT(11) NOT NULL,
  `id_ujian` INT(11) NOT NULL,
  `jenis_pelanggaran` VARCHAR(100) DEFAULT NULL,
  `waktu` DATETIME DEFAULT CURRENT_TIMESTAMP(),
  PRIMARY KEY (`id`),
  KEY `id_siswa` (`id_siswa`),
  KEY `id_ujian` (`id_ujian`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =======================================
-- Table structure for table `paket_ujian`
-- =======================================
DROP TABLE IF EXISTS `paket_ujian`;
CREATE TABLE `paket_ujian` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `nama_paket` VARCHAR(100) DEFAULT NULL,
  `jenis` ENUM('UTS','UAS','TRYOUT','ASESMEN') DEFAULT NULL,
  `tahun` VARCHAR(9) DEFAULT NULL,
  `status` ENUM('Aktif','Nonaktif') DEFAULT 'Nonaktif',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =======================================
-- Table structure for table `sekolah`
-- =======================================
DROP TABLE IF EXISTS `sekolah`;
CREATE TABLE `sekolah` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `nama_aplikasi` VARCHAR(100) DEFAULT NULL,
  `nama_sekolah` VARCHAR(150) DEFAULT NULL,
  `alamat` TEXT DEFAULT NULL,
  `npsn` VARCHAR(20) DEFAULT NULL,
  `telp` VARCHAR(20) DEFAULT NULL,
  `kepala_sekolah` VARCHAR(100) DEFAULT NULL,
  `logo` VARCHAR(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =======================================
-- Table structure for table `soal`
-- =======================================
DROP TABLE IF EXISTS `soal`;
CREATE TABLE `soal` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `id_ujian` INT(11) NOT NULL,
  `tipe` ENUM('pg','essay') DEFAULT 'pg',
  `soal` TEXT NOT NULL,
  `a` TEXT DEFAULT NULL,
  `b` TEXT DEFAULT NULL,
  `c` TEXT DEFAULT NULL,
  `d` TEXT DEFAULT NULL,
  `e` TEXT DEFAULT NULL,
  `kunci` CHAR(1) DEFAULT NULL,
  `gambar` VARCHAR(150) DEFAULT NULL,
  `audio` VARCHAR(150) DEFAULT NULL,
  `bobot` INT(11) DEFAULT 1,
  `urutan` INT(11) DEFAULT 0,
  `status` TINYINT(1) DEFAULT 1,
  `dibuat` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP(),
  `diubah` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP() ON UPDATE CURRENT_TIMESTAMP(),
  PRIMARY KEY (`id`),
  KEY `id_ujian` (`id_ujian`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =======================================
-- Table structure for table `token`
-- =======================================
DROP TABLE IF EXISTS `token`;
CREATE TABLE `token` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `token` VARCHAR(10) NOT NULL,
  `id_ujian` INT(11) NOT NULL,
  `aktif` ENUM('Y','N') DEFAULT 'Y',
  `created_at` DATETIME DEFAULT CURRENT_TIMESTAMP(),
  PRIMARY KEY (`id`),
  KEY `token` (`token`),
  KEY `id_ujian` (`id_ujian`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =======================================
-- Table structure for table `ujian`
-- =======================================
DROP TABLE IF EXISTS `ujian`;
CREATE TABLE `ujian` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `id_paket` INT(11) DEFAULT NULL,
  `id_mapel` INT(11) DEFAULT NULL,
  `id_kelas` INT(11) DEFAULT NULL,
  `nama_ujian` VARCHAR(100) DEFAULT NULL,
  `durasi` INT(11) DEFAULT NULL,
  `acak_soal` ENUM('Y','N') DEFAULT 'Y',
  `acak_jawaban` ENUM('Y','N') DEFAULT 'Y',
  `status` ENUM('Aktif','Nonaktif') DEFAULT 'Nonaktif',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =======================================
-- Table structure for table `users`
-- =======================================
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `nama` VARCHAR(100) DEFAULT NULL,
  `username` VARCHAR(50) DEFAULT NULL,
  `password` VARCHAR(255) DEFAULT NULL,
  `role` VARCHAR(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =======================================
-- Table structure for table `webcam_log`
-- =======================================
DROP TABLE IF EXISTS `webcam_log`;
CREATE TABLE `webcam_log` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `id_siswa` INT(11) NOT NULL,
  `id_ujian` INT(11) NOT NULL,
  `foto` VARCHAR(255) NOT NULL,
  `keterangan` VARCHAR(100) DEFAULT NULL,
  `waktu` DATETIME DEFAULT CURRENT_TIMESTAMP(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- =======================================
-- Dump Selesai
-- =======================================
