SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

/* =========================================================
   TABEL MASTER
========================================================= */

CREATE TABLE IF NOT EXISTS tahun_pelajaran (
  id INT AUTO_INCREMENT PRIMARY KEY,
  tahun VARCHAR(20),
  aktif ENUM('Y','N') DEFAULT 'N'
) ENGINE=InnoDB;


/* --------------------------------------------------------- */

CREATE TABLE IF NOT EXISTS kelas (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nama_kelas VARCHAR(50) UNIQUE
) ENGINE=InnoDB;

/* --------------------------------------------------------- */

CREATE TABLE IF NOT EXISTS sekolah (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nama_aplikasi VARCHAR(100),
  nama_sekolah VARCHAR(150),
  alamat TEXT,
  npsn VARCHAR(20),
  telp VARCHAR(20),
  kepala_sekolah VARCHAR(100),
  logo VARCHAR(100)
) ENGINE=InnoDB;

/* =========================================================
   USERS & SISWA
========================================================= */

CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nama VARCHAR(100),
  username VARCHAR(50),
  password VARCHAR(255),
  role VARCHAR(20)
) ENGINE=InnoDB;


/* --------------------------------------------------------- */

CREATE TABLE IF NOT EXISTS siswa (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nisn VARCHAR(20) UNIQUE,
  nama VARCHAR(150),
  jk ENUM('L','P'),
  tempat_lahir VARCHAR(100),
  tanggal_lahir DATE,
  kelas VARCHAR(50),
  username VARCHAR(20) UNIQUE,
  password VARCHAR(255),
  status ENUM('Aktif','Nonaktif') DEFAULT 'Aktif',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

/* =========================================================
   MAPEL & PAKET
========================================================= */

CREATE TABLE IF NOT EXISTS mapel (
  id INT AUTO_INCREMENT PRIMARY KEY,
  no_urut INT,
  nama_mapel VARCHAR(150),
  kode_mapel VARCHAR(20),
  kelompok VARCHAR(10),
  kelas VARCHAR(10),
  status ENUM('Aktif','Nonaktif') DEFAULT 'Aktif'
) ENGINE=InnoDB;

/* --------------------------------------------------------- */

CREATE TABLE IF NOT EXISTS paket_ujian (
  id INT AUTO_INCREMENT PRIMARY KEY,
  nama_paket VARCHAR(100),
  jenis ENUM('UTS','UAS','TRYOUT','ASESMEN'),
  tahun VARCHAR(9),
  status ENUM('Aktif','Nonaktif') DEFAULT 'Nonaktif'
) ENGINE=InnoDB;

/* =========================================================
   UJIAN & TOKEN
========================================================= */

CREATE TABLE IF NOT EXISTS ujian (
  id INT AUTO_INCREMENT PRIMARY KEY,
  id_paket INT,
  id_mapel INT,
  nama_ujian VARCHAR(100),
  durasi INT,
  acak_soal ENUM('Y','N') DEFAULT 'Y',
  acak_jawaban ENUM('Y','N') DEFAULT 'Y',
  kelas VARCHAR(10),
  status ENUM('Aktif','Nonaktif') DEFAULT 'Nonaktif'
) ENGINE=InnoDB;

/* --------------------------------------------------------- */

CREATE TABLE IF NOT EXISTS token (
  id INT AUTO_INCREMENT PRIMARY KEY,
  token VARCHAR(10),
  id_ujian INT,
  aktif ENUM('Y','N') DEFAULT 'Y',
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
  KEY (token),
  FOREIGN KEY (id_ujian) REFERENCES ujian(id) ON DELETE CASCADE
) ENGINE=InnoDB;

/* =========================================================
   SOAL & JAWABAN
========================================================= */

CREATE TABLE IF NOT EXISTS soal (
  id INT AUTO_INCREMENT PRIMARY KEY,
  id_ujian INT,
  tipe ENUM('pg','essay') DEFAULT 'pg',
  soal TEXT,
  a TEXT,
  b TEXT,
  c TEXT,
  d TEXT,
  e TEXT,
  kunci CHAR(1),
  gambar VARCHAR(150),
  audio VARCHAR(150),
  bobot INT DEFAULT 1,
  urutan INT DEFAULT 0,
  status TINYINT DEFAULT 1,
  dibuat TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  diubah TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (id_ujian) REFERENCES ujian(id) ON DELETE CASCADE
) ENGINE=InnoDB;

/* --------------------------------------------------------- */

CREATE TABLE IF NOT EXISTS jawaban (
  id INT AUTO_INCREMENT PRIMARY KEY,
  id_ujian INT,
  id_siswa INT,
  id_soal INT,
  tipe ENUM('pg','essay'),
  jawaban_pg CHAR(1),
  jawaban_essay TEXT,
  nilai INT,
  dibuat TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  UNIQUE KEY unik_jawaban (id_siswa,id_soal),
  FOREIGN KEY (id_ujian) REFERENCES ujian(id) ON DELETE CASCADE,
  FOREIGN KEY (id_siswa) REFERENCES siswa(id) ON DELETE CASCADE,
  FOREIGN KEY (id_soal) REFERENCES soal(id) ON DELETE CASCADE
) ENGINE=InnoDB;

/* =========================================================
   HASIL & LOGIN
========================================================= */

CREATE TABLE IF NOT EXISTS hasil (
  id INT AUTO_INCREMENT PRIMARY KEY,
  id_siswa INT,
  id_ujian INT,
  nilai INT DEFAULT 0,
  selesai DATETIME,
  UNIQUE KEY unik_siswa_ujian (id_siswa,id_ujian)
) ENGINE=InnoDB;

/* --------------------------------------------------------- */

CREATE TABLE IF NOT EXISTS login_siswa (
  id INT AUTO_INCREMENT PRIMARY KEY,
  id_siswa INT,
  id_ujian INT,
  status ENUM('login','mengerjakan','selesai') DEFAULT 'login',
  last_active DATETIME,
  login_time DATETIME DEFAULT CURRENT_TIMESTAMP,
  logout_time DATETIME,
  force_logout TINYINT DEFAULT 0,
  UNIQUE KEY uniq_siswa_ujian (id_siswa,id_ujian),
  FOREIGN KEY (id_siswa) REFERENCES siswa(id) ON DELETE CASCADE,
  FOREIGN KEY (id_ujian) REFERENCES ujian(id) ON DELETE CASCADE
) ENGINE=InnoDB;

/* =========================================================
   MONITORING
========================================================= */

CREATE TABLE IF NOT EXISTS pelanggaran_ujian (
  id INT AUTO_INCREMENT PRIMARY KEY,
  id_siswa INT,
  id_ujian INT,
  jenis_pelanggaran VARCHAR(100),
  waktu DATETIME DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (id_siswa) REFERENCES siswa(id) ON DELETE CASCADE,
  FOREIGN KEY (id_ujian) REFERENCES ujian(id) ON DELETE CASCADE
) ENGINE=InnoDB;

/* --------------------------------------------------------- */

CREATE TABLE IF NOT EXISTS webcam_log (
  id INT AUTO_INCREMENT PRIMARY KEY,
  id_siswa INT,
  id_ujian INT,
  foto VARCHAR(255),
  keterangan VARCHAR(100),
  waktu DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

/* --------------------------------------------------------- */

CREATE TABLE IF NOT EXISTS acak_opsi (
  id_siswa INT,
  id_soal INT,
  huruf_tampil CHAR(1),
  huruf_asli CHAR(1),
  PRIMARY KEY (id_siswa,id_soal,huruf_tampil)
) ENGINE=InnoDB;
