<?php
session_start();
require __DIR__ . '/../config/database.php'; // $conn (CBT), $conn2 (PKBM)

/* ================= PROFIL SEKOLAH ================= */
$nama_sekolah = 'SEKOLAH';
$logo = 'default.png';

$q = mysqli_query($conn,"SELECT nama_sekolah, logo FROM sekolah LIMIT 1");
if ($q && mysqli_num_rows($q)) {
    $s = mysqli_fetch_assoc($q);
    $nama_sekolah = $s['nama_sekolah'] ?: $nama_sekolah;
    $logo = $s['logo'] ?: $logo;
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) {
    $logo = 'default.png';
}

/* ================= CEK SUDAH LOGIN ================= */
if (!empty($_SESSION['login_siswa'])) {
    header("Location: ../siswa/biodata_siswa.php");
    exit;
}

$error = '';

/* ================= PROSES LOGIN ================= */
if (isset($_POST['login'])) {

    $username = strtoupper(trim($_POST['username']));
    $password = trim($_POST['password']);

    // ambil siswa dari PKBM
    $stmt = mysqli_prepare($conn2, "
        SELECT id, nisn, nama, kelas_id, tanggal_lahir
        FROM siswa
        WHERE username=? AND status='Aktif'
        LIMIT 1
    ");
    mysqli_stmt_bind_param($stmt,"s",$username);
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);

    if ($res && mysqli_num_rows($res) === 1) {
        $siswa = mysqli_fetch_assoc($res);

        // password = tanggal lahir
        if ($password !== date('dmY', strtotime($siswa['tanggal_lahir']))) {
            $error = "Username atau Password salah!";
            goto end;
        }

        // cek ujian aktif
        $qUjian = mysqli_query($conn,"
            SELECT id FROM ujian
            WHERE id_kelas={$siswa['kelas_id']} AND status='Aktif'
            LIMIT 1
        ");

        if (!$qUjian || !mysqli_num_rows($qUjian)) {
            $error = "Tidak ada ujian aktif!";
            goto end;
        }

        $ujian = mysqli_fetch_assoc($qUjian);
        $id_ujian = (int)$ujian['id'];
        $id_siswa = (int)$siswa['id'];

        // cek status login
        $cek = mysqli_query($conn,"
            SELECT status FROM login_siswa
            WHERE id_siswa=$id_siswa AND id_ujian=$id_ujian
            LIMIT 1
        ");
        if ($cek && mysqli_num_rows($cek)) {
            $ls = mysqli_fetch_assoc($cek);
            if ($ls['status'] === 'selesai') {
                $error = "Ujian sudah selesai. Login tidak diizinkan.";
                goto end;
            }
        }

        // set session
        session_regenerate_id(true);
        $_SESSION['login_siswa'] = true;
        $_SESSION['siswa'] = [
            'id'       => $id_siswa,
            'nisn'     => $siswa['nisn'],
            'nama'     => $siswa['nama'],
            'kelas_id' => $siswa['kelas_id']
        ];

        // catat login
        mysqli_query($conn,"
            INSERT INTO login_siswa (id_siswa,id_ujian,status,login_time,last_active)
            VALUES ($id_siswa,$id_ujian,'login',NOW(),NOW())
            ON DUPLICATE KEY UPDATE
                status='login',
                last_active=NOW()
        ");

        header("Location: ../siswa/biodata_siswa.php");
        exit;
    }

    $error = "Username atau Password salah!";
}
end:
?>

<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Login Peserta Ujian</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{
    min-height:100vh;
    margin:0;
    display:flex;
    justify-content:center;
    align-items:center;
    background:url('../assets/wall/wall3.jpg') center/cover fixed no-repeat;
}
.overlay{
    position:fixed;
    inset:0;
    background:rgba(0,0,0,.55);
}
.login-card{
    width:100%;
    max-width:380px;
    border-radius:18px;
    backdrop-filter: blur(8px);
    background:rgba(255,255,255,.92);
    z-index:2;
}
.logo{
    width:72px;
    height:auto;
    margin-bottom:10px;
}
input{
    text-align:center;
}
.btn-primary{
    border-radius:12px;
    font-weight:600;
}
@media(max-width:576px){
    h5{font-size:1.05rem}
    input,button{font-size:.9rem}
}
</style>
</head>

<body>
<div class="overlay"></div>

<div class="card shadow login-card">
<div class="card-body p-4 text-center">

<img src="../assets/logo/<?= htmlspecialchars($logo) ?>" class="logo">
<h6 class="fw-bold mb-1"><?= htmlspecialchars($nama_sekolah) ?></h6>
<small class="text-muted d-block mb-3">Computer Based Test</small>

<h5 class="fw-bold text-primary mb-3">LOGIN PESERTA UJIAN</h5>

<?php if($error): ?>
<div class="alert alert-danger py-2"><?= htmlspecialchars($error) ?></div>
<?php endif; ?>

<form method="post" autocomplete="off">
<input name="username" class="form-control mb-3" placeholder="Username" required autofocus>
<input type="password" name="password" class="form-control mb-3" placeholder="Password (ddmmyyyy)" required>
<button name="login" class="btn btn-primary w-100">MASUK</button>
</form>

<p class="text-muted mt-3 mb-0" style="font-size:12px">
Password awal = tanggal lahir (ddmmyyyy)
</p>

</div>
</div>
</body>
</html>
