<?php
session_start();
require '../config/database.php';

$qLogo = mysqli_query($conn, "SELECT logo FROM sekolah LIMIT 1");
$dataLogo = mysqli_fetch_assoc($qLogo);

$logoSekolah = (!empty($dataLogo['logo']) && file_exists(__DIR__ . '/../assets/logo/' . $dataLogo['logo']))
    ? '../assets/logo/' . $dataLogo['logo']
    : '../assets/logo/logo.png'; // fallback
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title>Login CBT</title>

<!-- FAVICON -->
<link rel="icon" type="image/png" href="../assets/logo.png">

<!-- BOOTSTRAP -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
  margin:0;
  background:linear-gradient(135deg,#f7e38c,#b9e4a6,#a3d9f5);
  display:flex;
  justify-content:center;
  align-items:center;
  height:100vh
}

.card{
  border-radius:16px;
  padding:2rem 1.5rem;
  box-shadow: 0 6px 18px rgba(0,0,0,.2);
}

.logo-login{
  display:block;
  margin:0 auto 15px auto;
  max-width:130px;
  height:auto;
}

.footer{
  font-size:12px;
  color:#adb5bd;
}

button:hover{
  opacity:0.95;
}
</style>
</head>

<body>
<form class="card w-100 shadow" style="max-width:360px" method="post" action="proses.php">

  <img src="<?= htmlspecialchars($logoSekolah) ?>" class="logo-login" alt="Logo">

  <h4 class="text-center mb-4 fw-bold text-primary">
    LOGIN CBT
  </h4>

  <input class="form-control mb-3" name="username" placeholder="Username" required>
  <input class="form-control mb-4" type="password" name="password" placeholder="Password" required>

  <button class="btn btn-primary w-100 mb-2 fw-semibold">LOGIN</button>
  <a href="/pkbm-test/index.html" class="btn btn-secondary w-100">Batal</a>

  <div class="text-center footer mt-3">
    Dikembangkan oleh <b>Bang Zae</b>
  </div>
</form>

<?php if (!empty($_SESSION['login_sukses'])): ?>
<div class="modal fade" id="loginSuccess" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content text-center shadow">
      <div class="modal-body p-4">
        <i class="bi bi-check-circle-fill text-success fs-1 mb-3"></i>
        <h5 class="fw-bold">Login Berhasil</h5>
        <p class="text-muted mb-0">
          Selamat datang, <b><?= htmlspecialchars($_SESSION['user']['nama']) ?></b>
        </p>
      </div>
    </div>
  </div>
</div>
<script>
const modal = new bootstrap.Modal(document.getElementById('loginSuccess'));
modal.show();
setTimeout(() => window.location.href = "../admin/", 1800);
</script>
<?php unset($_SESSION['login_sukses']); endif; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
