<?php
require 'init.php';

/* ===============================
   PROTEKSI LOGIN ADMIN
================================ */
if (empty($_SESSION['login'])) {
    header("Location: ../auth/login.php");
    exit;
}

/* ===============================
   CSRF TOKEN
================================ */
if (empty($_SESSION['csrf'])) {
    $_SESSION['csrf'] = bin2hex(random_bytes(32));
}

/* ===============================
   AMBIL 1 PAKET AKTIF (AMAN)
================================ */
$paketQ = mysqli_query($conn,"
    SELECT * FROM paket_ujian
    WHERE status='Aktif'
    ORDER BY id DESC
    LIMIT 1
");
$paket = mysqli_fetch_assoc($paketQ);
if (!$paket) {
    die("❌ PAKET UJIAN BELUM DIAKTIFKAN");
}

/* ===============================
   SIMPAN UJIAN
================================ */
if (isset($_POST['simpan'])) {

    /* validasi csrf */
    if (!hash_equals($_SESSION['csrf'], $_POST['csrf'])) {
        die("❌ TOKEN FORM TIDAK VALID");
    }

    /* sanitasi & validasi */
    $nama   = trim($_POST['nama']);
    $mapel  = (int) $_POST['id_mapel'];
    $durasi = (int) $_POST['durasi'];

    $acak_soal    = ($_POST['acak_soal'] === 'Y') ? 'Y' : 'N';
    $acak_jawaban = ($_POST['acak_jawaban'] === 'Y') ? 'Y' : 'N';

    if ($nama === '' || $durasi <= 0) {
        $error = "Nama ujian dan durasi wajib diisi!";
    } else {

        $nama = mysqli_real_escape_string($conn, $nama);

        mysqli_query($conn,"
            INSERT INTO ujian
            (id_paket,id_mapel,nama_ujian,durasi,acak_soal,acak_jawaban,status)
            VALUES
            ('$paket[id]','$mapel','$nama','$durasi',
             '$acak_soal','$acak_jawaban','Nonaktif')
        ");

        header("Location: ujian_paket.php");
        exit;
    }
}

/* ===============================
   DATA MAPEL
================================ */
$mapel = mysqli_query($conn,"
    SELECT * FROM mapel
    ORDER BY nama_mapel ASC
");

/* ===============================
   DATA UJIAN SESUAI PAKET
================================ */
$ujian = mysqli_query($conn,"
    SELECT u.*, m.nama_mapel
    FROM ujian u
    JOIN mapel m ON u.id_mapel = m.id
    WHERE u.id_paket = '$paket[id]'
    ORDER BY u.id DESC
");
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Ujian Paket</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body class="p-4 bg-light">

<h5 class="mb-3">📦 Paket Aktif: <b><?= htmlspecialchars($paket['nama_paket']) ?></b></h5>

<?php if(!empty($error)): ?>
<div class="alert alert-danger"><?= $error ?></div>
<?php endif; ?>

<form method="post" class="row g-2 mb-4">
<input type="hidden" name="csrf" value="<?= $_SESSION['csrf'] ?>">

<div class="col-md-3">
    <input name="nama" class="form-control" placeholder="Nama Ujian" required>
</div>

<div class="col-md-2">
    <select name="id_mapel" class="form-select" required>
        <?php while($m=mysqli_fetch_assoc($mapel)): ?>
        <option value="<?= $m['id'] ?>"><?= htmlspecialchars($m['nama_mapel']) ?></option>
        <?php endwhile ?>
    </select>
</div>

<div class="col-md-2">
    <input name="durasi" type="number" min="1" class="form-control" placeholder="Durasi (menit)" required>
</div>

<div class="col-md-2">
    <select name="acak_soal" class="form-select">
        <option value="Y">Acak Soal</option>
        <option value="N">Tetap</option>
    </select>
</div>

<div class="col-md-2">
    <select name="acak_jawaban" class="form-select">
        <option value="Y">Acak Jawaban</option>
        <option value="N">Tetap</option>
    </select>
</div>

<div class="col-md-1 d-grid">
    <button name="simpan" class="btn btn-primary">Tambah</button>
</div>
</form>

<table class="table table-bordered table-striped">
<thead class="table-dark">
<tr>
    <th>Mapel</th>
    <th>Nama Ujian</th>
    <th>Durasi</th>
    <th>Status</th>
</tr>
</thead>
<tbody>
<?php if(mysqli_num_rows($ujian)==0): ?>
<tr><td colspan="4" class="text-center text-muted">Belum ada ujian</td></tr>
<?php endif; ?>

<?php while($u=mysqli_fetch_assoc($ujian)): ?>
<tr>
<td><?= htmlspecialchars($u['nama_mapel']) ?></td>
<td><?= htmlspecialchars($u['nama_ujian']) ?></td>
<td><?= $u['durasi'] ?> menit</td>
<td>
    <span class="badge <?= $u['status']=='Aktif'?'bg-success':'bg-secondary' ?>">
        <?= $u['status'] ?>
    </span>
</td>
</tr>
<?php endwhile ?>
</tbody>
</table>

</body>
</html>
