<?php
require __DIR__ . '/../config/database.php';

/* ================= SESSION ================= */
if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['login'])) {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= PROFIL SEKOLAH ================= */
$nama_aplikasi='SMART CBT';
$nama_sekolah='SEKOLAH';
$logo='default.png';

$tables=['profil_sekolah','profil_aplikasi','setting','sekolah'];
foreach($tables as $t){
    $c=mysqli_query($conn,"SHOW TABLES LIKE '$t'");
    if($c && mysqli_num_rows($c)){
        $q=mysqli_query($conn,"SELECT * FROM `$t` LIMIT 1");
        if($q && mysqli_num_rows($q)){
            $s=mysqli_fetch_assoc($q);
            $nama_aplikasi=$s['nama_aplikasi']??$nama_aplikasi;
            $nama_sekolah=$s['nama_sekolah']??$nama_sekolah;
            $logo=$s['logo']??$logo;
        }
        break;
    }
}
if(!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= LIST KELAS (DARI SISWA) ================= */
$kelasList=[];
$qk=mysqli_query($conn,"SELECT DISTINCT kelas FROM siswa WHERE kelas!='' ORDER BY kelas");
while($r=mysqli_fetch_assoc($qk)){
    $kelasList[]=$r['kelas'];
}

/* ================= CRUD ================= */
if(isset($_POST['simpan'])){
    mysqli_query($conn,"
        INSERT INTO mapel
        (no_urut,nama_mapel,kode_mapel,kelompok,kelas,status)
        VALUES
        (
            '$_POST[no_urut]',
            '$_POST[nama_mapel]',
            '$_POST[kode_mapel]',
            '$_POST[kelompok]',
            '$_POST[kelas]',
            '$_POST[status]'
        )
    ");
    header("Location: mapel.php"); exit;
}

if(isset($_POST['update'])){
    mysqli_query($conn,"
        UPDATE mapel SET
        no_urut='$_POST[no_urut]',
        nama_mapel='$_POST[nama_mapel]',
        kode_mapel='$_POST[kode_mapel]',
        kelompok='$_POST[kelompok]',
        kelas='$_POST[kelas]',
        status='$_POST[status]'
        WHERE id='$_POST[id]'
    ");
    header("Location: mapel.php"); exit;
}

if(isset($_GET['hapus'])){
    mysqli_query($conn,"DELETE FROM mapel WHERE id=".(int)$_GET['hapus']);
    header("Location: mapel.php"); exit;
}

if(isset($_POST['toggle'])){
    $status=$_POST['status']=='Aktif'?'Nonaktif':'Aktif';
    mysqli_query($conn,"UPDATE mapel SET status='$status' WHERE id=".(int)$_POST['id']);
    header("Location: mapel.php"); exit;
}

/* ================= DATA ================= */
$data=[];
$q=mysqli_query($conn,"SELECT * FROM mapel ORDER BY kelas,kelompok,no_urut");
while($r=mysqli_fetch_assoc($q)){
    $group=$r['kelas'].' | Kelompok '.$r['kelompok'];
    $data[$group][]=$r;
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Mata Pelajaran</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{background:#f4f6f9}

.sidebar{
  width:260px;
  min-height:100vh;
  background:#1f2937;
  color:#fff;
  position:fixed;
}

.brand{
  padding:16px;
  background:#111827;
  display:flex;
  gap:12px;
  align-items:center;
}

.brand img{
  width:36px;
  height:36px;
  object-fit:contain;
}

.sidebar a{
  color:#cbd5e1;
  padding:10px 16px;
  display:block;
  text-decoration:none;
}

.sidebar a:hover,
.sidebar a.active{
  background:#2563eb;
  color:#fff;
}

.submenu a{
  padding-left:42px;
  font-size:14px;
}

.content{
  margin-left:260px;
  padding:24px;
}
/* FOOTER */
.footer-fixed{
  position:fixed;
  bottom:10px;
  right:16px;
  font-size:13px;
  color:#000;
}

</style>
</head>

<body>

<!-- SIDEBAR -->
<div class="sidebar position-fixed">
  <div class="brand">
    <img src="../assets/logo/<?= htmlspecialchars($logo) ?>">
    <div>
      <div><?= htmlspecialchars($nama_aplikasi) ?></div>
      <small style="opacity:.7"><?= htmlspecialchars($nama_sekolah) ?></small>
    </div>
  </div>

  <a href="dashboard.php">
    <i class="bi bi-speedometer2 me-2"></i> Dashboard
  </a>

  <!-- MASTER DATA -->
  <a data-bs-toggle="collapse" href="#menuMaster" role="button" aria-expanded="true">
    <i class="bi bi-database me-2"></i> Master Data
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse show submenu" id="menuMaster">
    <a href="kelas.php">🏫 Kelas</a>
    <a href="mapel.php" class="active">📘 Mata Pelajaran</a>
    <a href="siswa.php">👨‍🎓 Siswa</a>
    <a href="tahun.php">📅 Tahun Pelajaran</a>
  </div>
  <!-- UJIAN -->
  <a data-bs-toggle="collapse" href="#menuUjian" role="button">
    <i class="bi bi-pencil-square me-2"></i> Ujian
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse submenu" id="menuUjian">
    <a href="cetak_kartu_kelas.php">🖨 Cetak Kartu</a>
    <a href="paket.php">📦 Paket Ujian</a>
    <a href="ujian.php">📝 Daftar Ujian</a>
    <a href="token.php">🔑 Token</a>
  </div>

  <!-- HASIL -->
  <a data-bs-toggle="collapse" href="#menuHasil" role="button">
    <i class="bi bi-bar-chart-line me-2"></i> Hasil
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse submenu" id="menuHasil">
    <a href="hasil.php">📊 Nilai</a>
    <a href="ranking.php">🏆 Ranking</a>
    <a href="laporan_jawaban.php">📝 Jawaban Siswa</a>
  </div>

  <a href="../auth/logout.php">
    <i class="bi bi-box-arrow-right me-2"></i> Logout
  </a>
</div>


<div class="content">

<h4 class="mb-3">📘 Mata Pelajaran</h4>

<button class="btn btn-primary btn-sm mb-3" data-bs-toggle="modal" data-bs-target="#tambah">
➕ Tambah Mapel
</button>

<div class="card">
<table class="table table-bordered align-middle mb-0">
<thead class="table-light">
<tr>
<th>No</th>
<th>Mapel</th>
<th>Kode</th>
<th>Kelas</th>
<th>Kelompok</th>
<th>Status</th>
<th width="120">Aksi</th>
</tr>
</thead>
<tbody>

<?php foreach($data as $g=>$rows): ?>
<tr class="group"><td colspan="7"><?= $g ?></td></tr>
<?php foreach($rows as $m): ?>
<tr>
<td><?= $m['no_urut'] ?></td>
<td><?= $m['nama_mapel'] ?></td>
<td><?= $m['kode_mapel'] ?></td>
<td><?= $m['kelas'] ?></td>
<td><?= $m['kelompok'] ?></td>
<td class="text-center">
<form method="post">
<input type="hidden" name="toggle">
<input type="hidden" name="id" value="<?= $m['id'] ?>">
<input type="hidden" name="status" value="<?= $m['status'] ?>">
<input type="checkbox" <?= $m['status']=='Aktif'?'checked':'' ?> onchange="this.form.submit()">
</form>
</td>
<td class="text-center">
<button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#edit<?= $m['id'] ?>">✏️</button>
<a href="?hapus=<?= $m['id'] ?>" class="btn btn-danger btn-sm"
onclick="return confirm('Hapus mapel?')">🗑</a>
</td>
</tr>
<?php endforeach; endforeach; ?>

</tbody>
</table>
</div>
</div>

<!-- MODAL TAMBAH -->
<div class="modal fade" id="tambah">
<div class="modal-dialog modal-dialog-centered">
<form method="post" class="modal-content">
<div class="modal-header"><h5>Tambah Mapel</h5></div>
<div class="modal-body">
<input name="no_urut" class="form-control mb-2" placeholder="No Urut" required>
<input name="nama_mapel" class="form-control mb-2" placeholder="Nama Mapel" required>
<input name="kode_mapel" class="form-control mb-2" placeholder="Kode Mapel" required>

<select name="kelas" class="form-select mb-2" required>
<option value="">Pilih Kelas</option>
<?php foreach($kelasList as $k): ?>
<option><?= $k ?></option>
<?php endforeach ?>
</select>

<select name="kelompok" class="form-select mb-2">
<option>A</option><option>B</option><option>C</option><option>MULOK</option>
</select>

<select name="status" class="form-select">
<option>Aktif</option><option>Nonaktif</option>
</select>
</div>
<div class="modal-footer">
<button name="simpan" class="btn btn-primary">Simpan</button>
</div>
</form>
</div>
</div>

<!-- MODAL EDIT -->
<?php foreach($data as $rows): foreach($rows as $m): ?>
<div class="modal fade" id="edit<?= $m['id'] ?>">
<div class="modal-dialog modal-dialog-centered">
<form method="post" class="modal-content">
<div class="modal-header"><h5>Edit Mapel</h5></div>
<div class="modal-body">
<input type="hidden" name="id" value="<?= $m['id'] ?>">
<input name="no_urut" class="form-control mb-2" value="<?= $m['no_urut'] ?>" required>
<input name="nama_mapel" class="form-control mb-2" value="<?= $m['nama_mapel'] ?>" required>
<input name="kode_mapel" class="form-control mb-2" value="<?= $m['kode_mapel'] ?>" required>

<select name="kelas" class="form-select mb-2" required>
<?php foreach($kelasList as $k): ?>
<option <?= $m['kelas']==$k?'selected':'' ?>><?= $k ?></option>
<?php endforeach ?>
</select>

<select name="kelompok" class="form-select mb-2">
<?php foreach(['A','B','C','MULOK'] as $k): ?>
<option <?= $m['kelompok']==$k?'selected':'' ?>><?= $k ?></option>
<?php endforeach ?>
</select>

<select name="status" class="form-select">
<option <?= $m['status']=='Aktif'?'selected':'' ?>>Aktif</option>
<option <?= $m['status']=='Nonaktif'?'selected':'' ?>>Nonaktif</option>
</select>
</div>
<div class="modal-footer">
<button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
<button name="update" class="btn btn-primary">Update</button>
</div>
</form>
</div>
</div>
<?php endforeach; endforeach ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<!-- ===== FOOTER ===== -->
<div class="footer-fixed">
  Dibuat Oleh : <b>Bang Zae</b>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
