<?php
require __DIR__ . '/../config/database.php';

/* KONEKSI DATABASE PKBM */
$conn2 = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if(!$conn2) die("Koneksi PKBM gagal");

/* =============================
   SESSION ADMIN
============================= */
if (session_status() === PHP_SESSION_NONE) session_start();
if (
    empty($_SESSION['login']) ||
    empty($_SESSION['user']) ||
    ($_SESSION['user']['role'] ?? '') !== 'admin'
) {
    header("Location: ../auth/login.php");
    exit;
}

/* =============================
   PROFIL SEKOLAH
============================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo          = 'default.png';

$qSekolah = mysqli_query($conn,"SELECT * FROM sekolah LIMIT 1");
if ($qSekolah && mysqli_num_rows($qSekolah)) {
    $s = mysqli_fetch_assoc($qSekolah);
    $nama_sekolah = $s['nama_sekolah'] ?? $nama_sekolah;
    $logo         = $s['logo'] ?? $logo;
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) {
    $logo = 'default.png';
}

/* =============================
   PROSES HAPUS
============================= */
if (isset($_POST['hapus_semua'])) {
    mysqli_query($conn,"TRUNCATE TABLE pelanggaran_ujian");
    header("Location: lihat_kecurangan.php");
    exit;
}

if (isset($_POST['hapus_terpilih']) && !empty($_POST['hapus'])) {
    $ids = array_map('intval', $_POST['hapus']);
    if($ids){
        $list = implode(',', $ids);
        mysqli_query($conn,"DELETE FROM pelanggaran_ujian WHERE id IN ($list)");
    }
    header("Location: lihat_kecurangan.php");
    exit;
}

/* =============================
   DATA PELANGGARAN (ANTI ERROR)
============================= */
$q = mysqli_query($conn,"
SELECT
  p.id,
  p.jenis_pelanggaran,
  p.waktu,
  p.id_siswa,
  u.nama_ujian
FROM pelanggaran_ujian p
JOIN ujian u ON u.id = p.id_ujian
ORDER BY p.waktu DESC
");

?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Pelanggaran Ujian</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{margin:0;background:#f4f6f9}
.sidebar{
  width:260px;
  min-height:100vh;
  background:#1f2937;
  color:#fff;
  position:fixed;
}
.brand{
  padding:16px;
  background:#111827;
  display:flex;
  gap:10px;
  align-items:center;
}
.brand img{width:36px}
.sidebar a{
  color:#cbd5e1;
  padding:10px 16px;
  display:block;
  text-decoration:none;
}
.sidebar a:hover{background:#2563eb;color:#fff}
.content{
  margin-left:260px;
  padding:24px;
}
.card{border-radius:16px}
</style>
</head>

<body>

<!-- SIDEBAR -->
<div class="sidebar">
  <div class="brand">
    <img src="../assets/logo/<?= htmlspecialchars($logo) ?>">
    <div>
      <b><?= htmlspecialchars($nama_aplikasi) ?></b><br>
      <small><?= htmlspecialchars($nama_sekolah) ?></small>
    </div>
  </div>

  <a href="dashboard.php"><i class="bi bi-speedometer2 me-2"></i>Dashboard</a>
  <a href="status_ujian_list.php" target="_blank">
    <i class="bi bi-camera-video me-2"></i>Status Ujian Live
  </a>
  <a href="lihat_kecurangan.php" class="active">
    <i class="bi bi-exclamation-triangle me-2"></i>Pelanggaran Siswa
  </a>
  <a href="../auth/logout.php">
    <i class="bi bi-box-arrow-right me-2"></i>Logout
  </a>
</div>

<!-- CONTENT -->
<div class="content">

<div class="card shadow">
<div class="card-body">

<h4 class="fw-bold mb-3">🚨 Riwayat Pelanggaran Ujian</h4>

<form method="post" onsubmit="return confirm('Yakin ingin menghapus data?')">

<div class="mb-3 d-flex gap-2">
  <button name="hapus_terpilih" class="btn btn-danger btn-sm">
    🗑 Hapus Terpilih
  </button>
  <button name="hapus_semua" class="btn btn-outline-danger btn-sm">
    🔥 Hapus Semua
  </button>
</div>

<table class="table table-bordered table-striped align-middle">
<thead class="table-dark">
<tr>
  <th width="40"><input type="checkbox" onclick="toggle(this)"></th>
  <th width="50">No</th>
  <th>Nama</th>
  <th width="90">Kelas</th>
  <th>Ujian</th>
  <th>Pelanggaran</th>
  <th width="160">Waktu</th>
</tr>
</thead>
<tbody>

<?php
if(!$q || mysqli_num_rows($q)==0):
?>
<tr><td colspan="7" class="text-center text-muted">Tidak ada pelanggaran</td></tr>
<?php
else:
$no=1;
while($r=mysqli_fetch_assoc($q)):

    /* Ambil data siswa dari PKBM */
    $siswa = mysqli_fetch_assoc(mysqli_query($conn2,"
        SELECT s.nama, k.nama_kelas
        FROM siswa s
        LEFT JOIN kelas k ON k.id=s.kelas_id
        WHERE s.id={$r['id_siswa']}
        LIMIT 1
    "));

?>
<tr>
  <td class="text-center">
    <input type="checkbox" name="hapus[]" value="<?= $r['id'] ?>">
  </td>
  <td class="text-center"><?= $no++ ?></td>
  <td><?= htmlspecialchars($siswa['nama'] ?? '-') ?></td>
  <td class="text-center"><?= htmlspecialchars($siswa['nama_kelas'] ?? '-') ?></td>
  <td><?= htmlspecialchars($r['nama_ujian']) ?></td>
  <td class="text-danger fw-bold"><?= htmlspecialchars($r['jenis_pelanggaran']) ?></td>
  <td><?= date('d-m-Y H:i:s', strtotime($r['waktu'])) ?></td>
</tr>
<?php endwhile; endif; ?>

</tbody>
</table>
</form>

</div>
</div>
</div>

<script>
function toggle(source){
  document.querySelectorAll('input[name="hapus[]"]').forEach(cb => {
    cb.checked = source.checked;
  });
}
</script>

</body>
</html>
