<?php
require __DIR__ . '/../config/database.php';

/* ================= SESSION ADMIN ================= */
if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= PARAMETER ================= */
$kelas     = $_GET['kelas'] ?? '';
$id_siswa  = ($_GET['siswa'] ?? 'Semua') !== 'Semua' ? (int)$_GET['siswa'] : 0;
$id_mapel  = ($_GET['mapel'] ?? 'Semua') !== 'Semua' ? (int)$_GET['mapel'] : 0;

if ($kelas === '') die('Parameter kelas tidak valid');

/* ================= PROFIL SEKOLAH ================= */
$nama_sekolah   = 'SEKOLAH';
$alamat_sekolah = '';
$logo           = 'default.png';

$qSekolah = mysqli_query($conn, "SHOW TABLES LIKE 'sekolah'");
if ($qSekolah && mysqli_num_rows($qSekolah)) {
    $s = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM sekolah LIMIT 1"));
    $nama_sekolah   = $s['nama_sekolah'] ?? $nama_sekolah;
    $alamat_sekolah = $s['alamat'] ?? '';
    $logo           = $s['logo'] ?? $logo;
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= AMBIL SISWA ================= */
$sqlSiswa = "
SELECT id, nama, nisn, kelas
FROM siswa
WHERE kelas = '".mysqli_real_escape_string($conn,$kelas)."'
".($id_siswa ? "AND id=$id_siswa" : "")."
ORDER BY nama
";
$qSiswa = mysqli_query($conn,$sqlSiswa);
if (!$qSiswa || mysqli_num_rows($qSiswa)==0) die('Data siswa tidak ditemukan');

/* ================= AMBIL MAPEL ================= */
$sqlMapel = "
SELECT DISTINCT
  m.id,
  m.nama_mapel
FROM ujian u
JOIN mapel m ON m.id = u.id_mapel
WHERE u.kelas = '".mysqli_real_escape_string($conn,$kelas)."'
".($id_mapel ? "AND m.id = $id_mapel" : "")."
ORDER BY m.nama_mapel
";
$qMapelMaster = mysqli_query($conn,$sqlMapel);

if (!$qMapelMaster || mysqli_num_rows($qMapelMaster) == 0) {
    die('Tidak ada mapel untuk kelas ini');
}

?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Lihat Jawaban Siswa</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{font-size:12px;background:#fff}
.garis-dinas{border-top:3px solid #000;border-bottom:1px solid #000;margin:12px 0 18px}
.table th{background:#e9ecef;text-align:center;border:1px solid #999}
.table td{border:1px solid #999;vertical-align:top}
@media print{
  @page{margin:10mm 20mm}
  .page-break{page-break-before:always}
}
</style>
</head>

<body onload="window.print()">

<!-- ================= KOP ================= -->
<table width="100%">
<tr>
<td width="90" class="text-center">
  <img src="../assets/logo/<?= htmlspecialchars($logo) ?>" width="80">
</td>
<td>
  <div class="fw-bold text-uppercase" style="font-size:16px">
    <?= htmlspecialchars($nama_sekolah) ?>
  </div>
  <div style="font-size:12px"><?= htmlspecialchars($alamat_sekolah) ?></div>
</td>
</tr>
</table>
<div class="garis-dinas"></div>

<?php
$firstSiswa = true;
while ($siswa = mysqli_fetch_assoc($qSiswa)):
if (!$firstSiswa) echo '<div class="page-break"></div>';
$firstSiswa = false;
?>

<!-- ================= IDENTITAS SISWA ================= -->
<table width="100%" class="mb-3">
<tr><td width="120">Nama</td><td>: <b><?= htmlspecialchars($siswa['nama']) ?></b></td></tr>
<tr><td>NISN</td><td>: <?= htmlspecialchars($siswa['nisn']) ?></td></tr>
<tr><td>Kelas</td><td>: <?= htmlspecialchars($siswa['kelas']) ?></td></tr>
</table>

<?php
mysqli_data_seek($qMapelMaster,0);
$firstMapel=true;
while ($m = mysqli_fetch_assoc($qMapelMaster)):
?>

<h6 class="fw-bold mt-4 mb-2">
Mata Pelajaran : <?= htmlspecialchars($m['nama_mapel']) ?>
</h6>

<table class="table table-bordered">
<thead>
<tr>
<th width="40">No</th>
<th>Soal</th>
<th width="120">Kunci</th>
<th width="120">Jawaban</th>
<th width="90">Status</th>
</tr>
</thead>
<tbody>

<?php
$sql = "
SELECT
 so.soal, so.tipe, so.kunci,
 so.a, so.b, so.c, so.d, so.e,
 j.jawaban_pg, j.jawaban_essay,
 ao.huruf_asli
FROM soal so
JOIN ujian u ON u.id = so.id_ujian
LEFT JOIN jawaban j
  ON j.id_soal = so.id
 AND j.id_siswa = {$siswa['id']}
LEFT JOIN acak_opsi ao
  ON ao.id_soal = so.id
 AND ao.id_siswa = j.id_siswa
 AND ao.huruf_tampil = j.jawaban_pg
WHERE u.id_mapel = {$m['id']}
ORDER BY so.id
";
$q = mysqli_query($conn,$sql);

$no=1;
if ($q && mysqli_num_rows($q)):
while($r=mysqli_fetch_assoc($q)):
$opsi=['A'=>$r['a'],'B'=>$r['b'],'C'=>$r['c'],'D'=>$r['d'],'E'=>$r['e']];
$jawab='-'; $kunci='-'; $benar=null;

if ($r['tipe']=='pg') {
  $huruf=$r['huruf_asli']?:$r['jawaban_pg'];
  if ($huruf && isset($opsi[$huruf])) $jawab=$opsi[$huruf];
  if (isset($opsi[$r['kunci']])) $kunci=$opsi[$r['kunci']];
  if ($huruf) $benar=($huruf==$r['kunci']);
} else {
  $jawab=$r['jawaban_essay']?:'-';
}
?>
<tr>
<td class="text-center"><?= $no++ ?></td>
<td><?= nl2br(htmlspecialchars($r['soal'])) ?></td>
<td><?= htmlspecialchars($kunci) ?></td>
<td><?= htmlspecialchars($jawab) ?></td>
<td class="text-center fw-bold
<?= $benar===true?'text-success':($benar===false?'text-danger':'') ?>">
<?= $benar===true?'BENAR':($benar===false?'SALAH':'') ?>
</td>
</tr>
<?php endwhile; else: ?>
<tr>
<td colspan="5" class="text-center text-muted">Tidak ada data soal</td>
</tr>
<?php endif; ?>

</tbody>
</table>

<?php endwhile; ?>
<?php endwhile; ?>

<!-- ================= TTD ================= -->
<div class="mt-5 text-end">
<p>Pengawas</p><br><br>
<p><b>( _______________________ )</b></p>
</div>

</body>
</html>
