<?php
session_start();
require '../config/database.php';

/* ================== PROTEKSI ADMIN ================== */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

/* ================== PROFIL SEKOLAH ================== */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo = 'default.png';

$q = mysqli_query($conn,"SELECT * FROM smart_cbt.sekolah LIMIT 1");
if ($q && mysqli_num_rows($q)) {
    $s = mysqli_fetch_assoc($q);
    $nama_sekolah = $s['nama_sekolah'] ?? $nama_sekolah;
    $logo = $s['logo'] ?? $logo;
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================== FILTER ================== */
$id_kelas = $_GET['kelas'] ?? '';
$id_siswa = ($_GET['siswa'] ?? '') === 'Semua' ? '' : ($_GET['siswa'] ?? '');
$id_mapel = ($_GET['mapel'] ?? '') === 'Semua' ? '' : ($_GET['mapel'] ?? '');

/* ================== DROPDOWN ================== */
$qKelas = mysqli_query($conn,"
    SELECT id,
           CONCAT(nama_kelas,'-',CHAR(64 + CAST(paket_id AS UNSIGNED))) AS nama_kelas
    FROM pkbm_taruna_qurani.kelas
    ORDER BY nama_kelas, paket_id
");

$qSiswa = false;
if ($id_kelas) {
    $qSiswa = mysqli_query($conn,"
        SELECT id, nama
        FROM pkbm_taruna_qurani.siswa
        WHERE kelas_id=".(int)$id_kelas."
        ORDER BY nama
    ");
}

$qMapel = false;
if ($id_kelas) {
    $qMapel = mysqli_query($conn,"
        SELECT DISTINCT m.id, m.nama_mapel
        FROM smart_cbt.ujian u
        JOIN pkbm_taruna_qurani.mapel m ON m.id = u.id_mapel
        WHERE u.id_kelas=".(int)$id_kelas."
        ORDER BY m.nama_mapel
    ");
}

/* ================== WHERE ================== */
$where = [];
if ($id_kelas) $where[] = "u.id_kelas=".(int)$id_kelas;
if ($id_siswa) $where[] = "s.id=".(int)$id_siswa;
if ($id_mapel) $where[] = "u.id_mapel=".(int)$id_mapel;
$whereSQL = $where ? "WHERE ".implode(" AND ", $where) : "";

/* ================== QUERY LAPORAN ================== */
$sql = "
SELECT
  j.id,
  j.nilai,

  s.nama AS nama_siswa,
  CONCAT(k.nama_kelas,'-',CHAR(64 + CAST(k.paket_id AS UNSIGNED))) AS nama_kelas,
  m.nama_mapel,

  so.soal,
  so.tipe,
  so.kunci,
  so.a, so.b, so.c, so.d, so.e,

  j.jawaban_pg,
  j.jawaban_essay,
  ao.huruf_asli

FROM smart_cbt.jawaban j
JOIN smart_cbt.soal so ON so.id = j.id_soal
JOIN smart_cbt.ujian u ON u.id = j.id_ujian

JOIN pkbm_taruna_qurani.siswa s ON s.id = j.id_siswa
JOIN pkbm_taruna_qurani.kelas k ON k.id = u.id_kelas
LEFT JOIN pkbm_taruna_qurani.mapel m ON m.id = u.id_mapel

LEFT JOIN smart_cbt.acak_opsi ao
       ON ao.id_soal = so.id
      AND ao.id_siswa = j.id_siswa
      AND ao.huruf_tampil = j.jawaban_pg

$whereSQL
ORDER BY s.nama, so.id
";

$data = mysqli_query($conn,$sql);
if(!$data){
    die("Query Error: ".mysqli_error($conn));
}
?>

<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Laporan Jawaban Siswa</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{background:#f4f6f9;font-size:14px}
.sidebar{width:260px;min-height:100vh;background:#1f2937;color:#fff;position:fixed}
.brand{padding:16px;background:#111827;display:flex;gap:12px;align-items:center}
.brand img{width:36px}
.sidebar a{color:#cbd5e1;padding:10px 16px;display:block;text-decoration:none}
.sidebar a:hover,.sidebar a.active{background:#2563eb;color:#fff}
.submenu a{padding-left:42px}
.content{margin-left:260px;padding:24px}
@media print{
  .sidebar,.no-print{display:none}
  .content{margin:0}
}
.footer-fixed{
  position:fixed;
  bottom:10px;
  right:16px;
  font-size:13px;
  color:#555;
}
</style>
</head>

<body>

<!-- SIDEBAR -->
<div class="sidebar">
<div class="brand">
<img src="../assets/logo/<?= $logo ?>">
<div>
<div><?= $nama_aplikasi ?></div>
<small style="opacity:.7"><?= $nama_sekolah ?></small>
</div>
</div>
<a href="dashboard.php"><i class="bi bi-speedometer2 me-2"></i> Dashboard</a>
<a data-bs-toggle="collapse" href="#master">
    <i class="bi bi-database me-2"></i> Master Data
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse show submenu" id="master">
  </div>

  <a data-bs-toggle="collapse" href="#ujian">
  <i class="bi bi-pencil-square me-2"></i> Ujian
  <i class="bi bi-chevron-down float-end"></i>
</a>
<div class="collapse submenu" id="ujian">
  <a href="cetak_kartu_kelas.php">🖨 Cetak Kartu</a>
  <a href="paket.php">📦 Paket Ujian</a>
  <a href="ujian.php">📝 Daftar Ujian</a>
  <a href="token.php">🔑 Token</a>
</div>


  <a data-bs-toggle="collapse" href="#hasil">
  <i class="bi bi-bar-chart-line me-2"></i> Hasil
  <i class="bi bi-chevron-down float-end"></i>
</a>

<div class="collapse submenu" id="hasil">
  <a href="hasil.php">📊 Nilai</a>
  <a href="ranking.php">🏆 Ranking</a>
  <a href="laporan_jawaban.php">📝 Jawaban Siswa</a>
</div>


  <a href="../auth/logout.php">
    <i class="bi bi-box-arrow-right me-2"></i> Logout
  </a>
</div>
<div class="content">
<h4 class="fw-bold mb-3">📘 Laporan Jawaban Siswa</h4>

<!-- ===== FILTER ===== -->
<form method="get" class="row g-2 mb-3 no-print">

  <!-- KELAS -->
  <div class="col-md-3">
    <label>Kelas</label>
    <select name="kelas" class="form-select" onchange="this.form.submit()">
      <option value="">-- Pilih Kelas --</option>
<?php while($k=mysqli_fetch_assoc($qKelas)): ?>
<option value="<?= $k['id'] ?>" <?= $id_kelas==$k['id']?'selected':'' ?>>
  <?= htmlspecialchars($k['nama_kelas']) ?>
</option>
<?php endwhile ?>
    </select>
  </div>

  <!-- SISWA -->
  <div class="col-md-3">
    <label>Siswa</label>
    <select name="siswa" class="form-select" onchange="this.form.submit()">
      <option value="Semua">Semua Siswa</option>
<?php if($qSiswa): while($s=mysqli_fetch_assoc($qSiswa)): ?>
<option value="<?= $s['id'] ?>" <?= $id_siswa==$s['id']?'selected':'' ?>>
  <?= htmlspecialchars($s['nama']) ?>
</option>
<?php endwhile; endif ?>
    </select>
  </div>

  <!-- MAPEL -->
<div class="col-md-3">
  <label>Mapel</label>
  <select name="mapel" class="form-select" onchange="this.form.submit()">
    <option value="Semua">Semua Mapel</option>
<?php while($m=mysqli_fetch_assoc($qMapel)): ?>
    <option value="<?= $m['id'] ?>" <?= $id_mapel==$m['id']?'selected':'' ?>>
      <?= htmlspecialchars($m['nama_mapel']) ?>
    </option>
<?php endwhile ?>
  </select>
</div>


  <!-- AKSI -->
  <div class="col-md-3 d-flex align-items-end gap-2">

    <!-- CETAK -->
    <a target="_blank"
       href="lihat_jawaban.php?kelas=<?= urlencode($id_kelas) ?>&siswa=<?= urlencode($id_siswa ?: 'Semua') ?>&mapel=<?= urlencode($id_mapel ?: 'Semua') ?>"
       class="btn btn-success w-100">
       🖨 Cetak
    </a>

    <!-- EXCEL -->
    <a target="_blank"
       href="export_jawaban_excel.php?kelas=<?= urlencode($id_kelas) ?>&siswa=<?= urlencode($id_siswa ?: 'Semua') ?>&mapel=<?= urlencode($id_mapel ?: 'Semua') ?>"
       class="btn btn-outline-success w-100">
       📊 Excel
    </a>

  </div>
</form>


<!-- ===== TABEL ===== -->
<div class="card shadow-sm">
<div class="table-responsive">
<table class="table table-bordered align-middle">
<thead class="table-dark text-center">
<tr>
  <th>No</th>
  <th>Nama Siswa</th>
  <th>Kelas</th>
  <th>Soal</th>
  <th>Mapel</th>
  <th>Kunci</th>
  <th>Jawaban PG</th>
  <th>Jawaban Essay</th>
  <th>Status</th>
</tr>
</thead>
<tbody>

<?php if(mysqli_num_rows($data)==0): ?>
<tr><td colspan="8" class="text-center">Data tidak ditemukan</td></tr>
<?php else: $no=1; while($r=mysqli_fetch_assoc($data)):
  $opsi = [
  'A' => $r['a'],
  'B' => $r['b'],
  'C' => $r['c'],
  'D' => $r['d'],
  'E' => $r['e']
];


if ($r['tipe'] === 'pg') {

    // default
    $huruf_jawaban = null;
    $isi_jawaban_pg = '-';

    // 1. Jika ada huruf_asli (hasil dari acak)
    if (!empty($r['huruf_asli']) && isset($opsi[$r['huruf_asli']])) {

        $huruf_jawaban = $r['huruf_asli'];
        $isi_jawaban_pg = $opsi[$huruf_jawaban];

    }
    // 2. Jika jawaban_pg berupa huruf A–E
    elseif (in_array($r['jawaban_pg'], ['A','B','C','D','E']) && isset($opsi[$r['jawaban_pg']])) {

        $huruf_jawaban = $r['jawaban_pg'];
        $isi_jawaban_pg = $opsi[$huruf_jawaban];

    }
    // 3. Jika jawaban_pg berupa ISI JAWABAN (teks)
    elseif (!empty($r['jawaban_pg'])) {

        $isi_jawaban_pg = $r['jawaban_pg'];

        // cari huruf berdasarkan isi
        $huruf_jawaban = array_search($r['jawaban_pg'], $opsi, true);
    }

    // kunci
    $isi_kunci_pg = isset($opsi[$r['kunci']]) ? $opsi[$r['kunci']] : '-';

    // status benar/salah
    $status = ($huruf_jawaban === $r['kunci']);

} else {

    $isi_jawaban_pg = '-';
    $isi_kunci_pg   = '-';
    $status = null;

}


?>

<tr>
  <td class="text-center"><?= $no++ ?></td>
  <td><?= htmlspecialchars($r['nama_siswa']) ?></td>
  <td><?= htmlspecialchars($r['nama_kelas']) ?></td>
  <td><?= nl2br(htmlspecialchars($r['soal'])) ?></td>
  <td><?= htmlspecialchars($r['nama_mapel']) ?></td>
  <td>
  <?= $r['tipe']=='pg'
      ? nl2br(htmlspecialchars($isi_kunci_pg))
      : '-' ?>
</td>

<td>
  <?= $r['tipe']=='pg'
      ? nl2br(htmlspecialchars($isi_jawaban_pg))
      : '-' ?>
</td>

  <td><?= $r['jawaban_essay'] ? nl2br(htmlspecialchars($r['jawaban_essay'])) : '-' ?></td>
  <td class="text-center">

<?php if($r['tipe']=='pg'): ?>
  <span class="badge <?= $status?'bg-success':'bg-danger' ?>">
    <?= $status?'BENAR':'SALAH' ?>
  </span>

<?php else: ?>
  <span class="badge bg-secondary">ESSAY</span><br>

  <button
    class="btn btn-sm btn-primary mt-1"
    data-bs-toggle="modal"
    data-bs-target="#nilaiModal"
    data-id="<?= $r['id'] ?>"
    data-nilai="<?= $r['nilai'] ?>"
  >
    ✏ Nilai
  </button>
<?php endif ?>

</td>

</tr>

<?php endwhile; endif ?>
</tbody>
</table>
</div>
</div>

<!-- MODAL NILAI ESSAY -->
<div class="modal fade" id="nilaiModal" tabindex="-1">
  <div class="modal-dialog modal-sm">
    <form method="post" action="simpan_nilai_essay.php" class="modal-content">

      <div class="modal-header">
        <h5 class="modal-title">Input Nilai Essay</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <div class="modal-body">
        <input type="hidden" name="id_jawaban" id="id_jawaban">

        <input type="number"
               name="nilai"
               id="nilai"
               class="form-control"
               min="0"
               max="100"
               required>
      </div>

      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <button class="btn btn-primary">Simpan</button>
      </div>

    </form>
  </div>
</div>

<!-- ===== FOOTER ===== -->
<div class="footer-fixed">
  Dikembangkan oleh <b>Bang Zae</b>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
const nilaiModal = document.getElementById('nilaiModal');

nilaiModal.addEventListener('show.bs.modal', function (event) {
  const button = event.relatedTarget;

  document.getElementById('id_jawaban').value =
    button.getAttribute('data-id');

  document.getElementById('nilai').value =
    button.getAttribute('data-nilai') || '';
});
</script>

</body>
</html>
