<?php
require __DIR__ . '/../config/database.php';
if (session_status() === PHP_SESSION_NONE) session_start();

/* ================== KONEKSI DB PKBM ================== */
$conn2 = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if(!$conn2) die("Koneksi PKBM gagal: ".mysqli_connect_error());

/* ================== PROTEKSI ================== */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= PROFIL ================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo          = 'default.png';

$q = mysqli_query($conn,"SELECT * FROM sekolah LIMIT 1");
if ($q && mysqli_num_rows($q)) {
    $s = mysqli_fetch_assoc($q);
    $nama_sekolah = $s['nama_sekolah'] ?? $nama_sekolah;
    $logo = $s['logo'] ?? $logo;
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= FILTER ================= */
$filter_kelas = $_GET['kelas'] ?? '';
$filter_mapel = $_GET['mapel'] ?? '';

$where = [];
if($filter_kelas!='') $where[] = "u.id_kelas='$filter_kelas'";
if($filter_mapel!='') $where[] = "u.id_mapel='$filter_mapel'";

$whereSQL = count($where) ? "WHERE ".implode(" AND ",$where) : "";

/* ================= QUERY FINAL (ASLI + FILTER) ================= */
$sql = "
SELECT
    s.id AS id_siswa,
    s.nisn,
    s.nama,
    CONCAT(k.nama_kelas,'-',CHAR(64+k.paket_id)) AS nama_kelas,
    m.nama_mapel,
    h.nilai,
    h.selesai


FROM smart_cbt.hasil h
JOIN pkbm_taruna_qurani.siswa s ON s.id = h.id_siswa
JOIN smart_cbt.ujian u ON u.id = h.id_ujian
JOIN pkbm_taruna_qurani.kelas k ON k.id = u.id_kelas
LEFT JOIN pkbm_taruna_qurani.mapel m ON m.id = u.id_mapel

$whereSQL

ORDER BY s.nama, m.nama_mapel
";

$data = mysqli_query($conn,$sql);
if(!$data) die("SQL Error: ".mysqli_error($conn));
?>

<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Hasil Nilai</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{background:#f4f6f9}
.sidebar{width:260px;min-height:100vh;background:#1f2937;color:#fff;position:fixed}
.brand{padding:16px;background:#111827;display:flex;gap:12px;align-items:center}
.brand img{width:36px}
.sidebar a{color:#cbd5e1;padding:10px 16px;display:block;text-decoration:none}
.sidebar a:hover,.sidebar a.active{background:#2563eb;color:#fff}
.content{margin-left:260px;padding:24px}
</style>
</head>
<body>

<div class="sidebar">
<div class="brand">
<img src="../assets/logo/<?= $logo ?>">
<div>
<div><?= $nama_aplikasi ?></div>
<small><?= $nama_sekolah ?></small>
</div>
</div>
<a href="dashboard.php"><i class="bi bi-speedometer2 me-2"></i> Dashboard</a>
<a href="hasil.php" class="active"><i class="bi bi-bar-chart-line me-2"></i> Hasil</a>
<a href="../auth/logout.php"><i class="bi bi-box-arrow-right me-2"></i> Logout</a>
</div>

<div class="content">

<h4 class="fw-bold mb-3"><i class="bi bi-bar-chart-line"></i> Daftar Hasil Nilai</h4>

<!-- FILTER -->
<form class="row g-2 mb-3">
<div class="col-md-3">
<select name="kelas" class="form-select">
<option value="">- Semua Kelas -</option>
<?php
$qk = mysqli_query($conn2,"
  SELECT id, CONCAT(nama_kelas,'-',CHAR(64+paket_id)) AS kelas
  FROM kelas
  ORDER BY nama_kelas, paket_id
");
while($k=mysqli_fetch_assoc($qk)){
  $s = $filter_kelas==$k['id']?'selected':'';
  echo "<option value='{$k['id']}' $s>{$k['kelas']}</option>";
}
?>
</select>
</div>


<div class="col-md-3">
<select name="mapel" class="form-select">
<option value="">- Semua Mapel -</option>
<?php
$qm=mysqli_query($conn2,"SELECT * FROM mapel ORDER BY nama_mapel");
while($m=mysqli_fetch_assoc($qm)){
  $s = $filter_mapel==$m['id']?'selected':'';
  echo "<option value='{$m['id']}' $s>{$m['nama_mapel']}</option>";
}
?>
</select>
</div>

<div class="col-md-3">
<button class="btn btn-primary">
<i class="bi bi-search"></i> Filter
</button>

<a href="cetak_hasil.php?kelas=<?= $filter_kelas ?>&mapel=<?= $filter_mapel ?>" 
   target="_blank" 
   class="btn btn-success">
   <i class="bi bi-printer"></i> Cetak Filter
</a>

<a href="cetak_hasil.php" 
   target="_blank" 
   class="btn btn-dark">
   <i class="bi bi-printer"></i> Cetak Semua
</a>

</div>
</form>

<div class="card shadow-sm">
<div class="table-responsive">
<table class="table table-bordered align-middle">
<thead class="table-dark text-center">
<tr>
<th>No</th><th>NISN</th><th>Nama</th><th>Kelas</th>
<th>Mapel</th><th>Nilai</th><th>Selesai</th><th>Aksi</th>

</tr>
</thead>
<tbody>

<?php if(mysqli_num_rows($data)==0): ?>
<tr><td colspan="7" class="text-center">Data kosong</td></tr>
<?php else: $no=1; while($r=mysqli_fetch_assoc($data)): ?>
<tr>
<td class="text-center"><?= $no++ ?></td>
<td><?= htmlspecialchars($r['nisn']) ?></td>
<td><?= htmlspecialchars($r['nama']) ?></td>
<td><?= htmlspecialchars($r['nama_kelas']) ?></td>
<td><?= htmlspecialchars($r['nama_mapel']) ?></td>

<?php
$nilai = (int)$r['nilai'];
if($nilai >= 85)      $cls='bg-success';
elseif($nilai >= 75) $cls='bg-warning text-dark';
else                 $cls='bg-danger';
?>

<td class="text-center">
  <span class="badge <?= $cls ?>"><?= $nilai ?></span>
</td>

<td class="text-center">
<?= $r['selesai'] ? date('d-m-Y H:i',strtotime($r['selesai'])) : '-' ?>
</td>
<td class="text-center">
  <a href="cetak_hasil.php?siswa=<?= $r['id_siswa'] ?>" 
     target="_blank"
     class="btn btn-sm btn-primary">
     <i class="bi bi-printer"></i>
  </a>
</td>

</tr>
<?php endwhile; endif ?>

</tbody>
</table>
</div>
</div>

</div>
</body>
</html>
