<?php
require __DIR__ . '/../config/database.php';

/* =============================
   SESSION AMAN (ADMIN)
============================= */
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (
    empty($_SESSION['login']) ||
    empty($_SESSION['user']) ||
    ($_SESSION['user']['role'] ?? '') !== 'admin'
) {
    header("Location: ../auth/login.php");
    exit;
}

/* =============================
   PROFIL SEKOLAH (AUTO DETECT)
============================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo          = 'default.png';

$alamat  = 'Alamat belum diisi';
$telepon = '-';
$email   = '-'; // (tidak ada di tabel, biar aman)
$kepsek  = '-';
$npsn    = '-';


$possible_tables = ['profil_sekolah','profil_aplikasi','setting','sekolah'];
$table_used = null;

foreach ($possible_tables as $tbl) {
    $cek = mysqli_query($conn,"SHOW TABLES LIKE '$tbl'");
    if ($cek && mysqli_num_rows($cek)>0) {
        $table_used = $tbl;
        break;
    }
}

if (isset($_POST['simpan_profil'])) {

  $na = trim($_POST['nama_aplikasi'] ?? '');
  $ns = trim($_POST['nama_sekolah'] ?? '');
  $al = trim($_POST['alamat'] ?? '');
  $np = trim($_POST['npsn'] ?? '');
  $tl = trim($_POST['telp'] ?? '');
  $ks = trim($_POST['kepala_sekolah'] ?? '');

  $logo_baru = $logo;

  if (!empty($_FILES['logo']['name'])) {
    $ext = pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
    $nama_file = 'logo_' . time() . '.' . strtolower($ext);
    $target = __DIR__ . '/../assets/logo/' . $nama_file;

    if (move_uploaded_file($_FILES['logo']['tmp_name'], $target)) {
      $logo_baru = $nama_file;
    }
  }

  if ($table_used) {
    mysqli_query($conn,"
      UPDATE `$table_used` SET
        nama_aplikasi='$na',
        nama_sekolah='$ns',
        alamat='$al',
        npsn='$np',
        telp='$tl',
        kepala_sekolah='$ks',
        logo='$logo_baru'
      LIMIT 1
    ");
  }

  echo "<script>location.href='dashboard.php';</script>";
  exit;
}


if ($table_used) {
    $q = mysqli_query($conn,"SELECT * FROM `$table_used` LIMIT 1");
    if ($q && mysqli_num_rows($q)>0) {
        $s = mysqli_fetch_assoc($q);

        $nama_aplikasi = $s['nama_aplikasi'] ?? $nama_aplikasi;
        $nama_sekolah  = $s['nama_sekolah']  ?? $nama_sekolah;
        $logo          = $s['logo']          ?? $logo;

        $alamat  = $s['alamat']         ?? $alamat;
        $telepon = $s['telp']           ?? $telepon;   // FIX DI SINI
        $kepsek  = $s['kepala_sekolah'] ?? $kepsek;    // SUDAH BENAR
        $npsn    = $s['npsn']           ?? $npsn;      // TAMBAH
    }
}



if (!file_exists(__DIR__."/../assets/logo/$logo")) {
    $logo = 'default.png';
}

/* =============================
   FUNGSI HITUNG AMAN
============================= */
function hitung($conn,$table){
    $cek = mysqli_query($conn,"SHOW TABLES LIKE '$table'");
    if (!$cek || mysqli_num_rows($cek)==0) return 0;
    $q = mysqli_query($conn,"SELECT COUNT(*) total FROM `$table`");
    $r = mysqli_fetch_assoc($q);
    return $r['total'] ?? 0;
}

/* =============================
   DATA STATISTIK
============================= */
$jumlah_user  = hitung($conn,'users');
$jumlah_siswa = hitung($conn,'siswa');
$jumlah_soal  = hitung($conn,'soal');
$jumlah_ujian = hitung($conn,'ujian');
$jumlah_paket = hitung($conn,'paket_ujian');
$jumlah_hasil = hitung($conn,'hasil');
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($nama_aplikasi) ?> | Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<style>
/* BODY */
body{
  background:#f4f6f9;
  margin:0;
}

/* SIDEBAR */
.sidebar{
  width:260px;
  min-height:100vh;
  background:#1f2937;
  color:#fff;
  position:fixed;
  left:0;
  top:0;
}
.brand{
  padding:16px;
  background:#111827;
  display:flex;
  gap:12px;
  align-items:center;
}
.brand img{
  width:36px;
  height:36px;
  object-fit:contain;
}
.sidebar a{
  color:#cbd5e1;
  padding:10px 16px;
  display:block;
  text-decoration:none;
}
.sidebar a:hover,
.sidebar a.active{
  background:#2563eb;
  color:#fff;
}
.submenu a{
  padding-left:42px;
  font-size:14px;
}

/* CONTENT (BACKGROUND DI SINI) */
.content{
  margin-left:260px;
  padding:24px;
  min-height:100vh;

  background-image: url('../assets/wall/wall1.jpg');
  background-size: cover;
  background-position: center;
  background-repeat: no-repeat;
  background-attachment: fixed;
}

/* CARD */
.card{
  border-radius:16px;
  background:rgba(255,255,255,.95);
}
.stat-card{
  color:#fff;
}
.stat-card i{
  font-size:2.2rem;
  opacity:.8;
}

/* FOOTER */
.footer-fixed{
  position:fixed;
  bottom:10px;
  right:16px;
  font-size:13px;
  color:#fff;
}
.card h6{
  border-bottom:1px solid #e5e7eb;
  padding-bottom:6px;
  margin-bottom:12px;
}

</style>

</head>

<body>

<!-- SIDEBAR -->
<div class="sidebar position-fixed">
  <div class="brand">
    <img src="../assets/logo/<?= htmlspecialchars($logo) ?>">
    <div>
      <div><?= htmlspecialchars($nama_aplikasi) ?></div>
      <small style="opacity:.7"><?= htmlspecialchars($nama_sekolah) ?></small>
    </div>
  </div>

  <a href="dashboard.php" class="active">
    <i class="bi bi-speedometer2 me-2"></i> Dashboard
  </a>

  <a data-bs-toggle="collapse" href="#master">
    <i class="bi bi-database me-2"></i> Master Data
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse show submenu" id="master">
  </div>

 <a href="status_ujian_list.php" target="_blank" rel="noopener noreferrer">
  <i class="bi bi-camera-video me-2"></i>
  Status Ujian Live
</a>
 <!-- TAMBAHKAN DI SINI -->
  <a href="lihat_kecurangan.php">
    <i class="bi bi-exclamation-triangle me-2"></i>
    Pelanggaran Siswa
  </a>

  <a data-bs-toggle="collapse" href="#ujian">
  <i class="bi bi-pencil-square me-2"></i> Ujian
  <i class="bi bi-chevron-down float-end"></i>
</a>
<div class="collapse submenu" id="ujian">
  <a href="cetak_kartu_kelas.php">🖨 Cetak Kartu</a>
  <a href="paket.php">📦 Paket Ujian</a>
  <a href="ujian.php">📝 Daftar Ujian</a>
  <a href="token.php">🔑 Token</a>
</div>


  <a data-bs-toggle="collapse" href="#hasil">
  <i class="bi bi-bar-chart-line me-2"></i> Hasil
  <i class="bi bi-chevron-down float-end"></i>
</a>

<div class="collapse submenu" id="hasil">
  <a href="hasil.php">📊 Nilai</a>
  <a href="ranking.php">🏆 Ranking</a>
  <a href="laporan_jawaban.php">📝 Jawaban Siswa</a>
</div>


  <a href="../auth/logout.php">
    <i class="bi bi-box-arrow-right me-2"></i> Logout
  </a>
</div>

<!-- CONTENT -->
<div class="content">

<h4 class="fw-bold mb-1">Dashboard</h4>
<small class="text-muted">Selamat datang, <?= htmlspecialchars($_SESSION['user']['nama']) ?></small>

<div class="row g-4 my-4">
<?php
$cards = [
 ['primary',$jumlah_user,'Users','people-fill'],
 ['info',$jumlah_siswa,'Siswa','mortarboard-fill'],
 ['success',$jumlah_soal,'Soal','journal-text'],
 ['warning',$jumlah_ujian,'Ujian','pencil-square'],
 ['secondary',$jumlah_paket,'Paket','box-seam'],
 ['danger',$jumlah_hasil,'Hasil','clipboard-data']
];
foreach($cards as $c):
?>
<div class="col-lg-4 col-md-6">
<div class="card stat-card bg-<?= $c[0] ?> p-3 shadow">
<div class="d-flex justify-content-between">
<div>
<h3 class="fw-bold mb-0"><?= $c[1] ?></h3>
<small><?= $c[2] ?></small>
</div>
<i class="bi bi-<?= $c[3] ?>"></i>
</div>
</div>
</div>
<?php endforeach ?>
</div>


<div class="row g-4 mt-2">

  <!-- PROFIL SEKOLAH -->
  <div class="col-md-6">
    <div class="card shadow p-4">
      <div class="d-flex justify-content-between align-items-center">
  <h6 class="fw-bold mb-0">🏫 Profil Sekolah</h6>
  <button class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#modalProfil">
    <i class="bi bi-pencil-square"></i> Edit
  </button>
</div>

      <div class="d-flex align-items-center mb-3">
        <img src="../assets/logo/<?= htmlspecialchars($logo) ?>" 
             style="width:64px;height:64px;object-fit:contain"
             class="me-3 border rounded p-1">
        <div>
          <div class="fw-bold"><?= htmlspecialchars($nama_sekolah) ?></div>
          <small class="text-muted"><?= htmlspecialchars($nama_aplikasi) ?></small>
        </div>
      </div>
      <ul class="mb-0 small">
  <li><b>Alamat:</b> <?= htmlspecialchars($alamat) ?></li>
  <li><b>NPSN:</b> <?= htmlspecialchars($npsn) ?></li>
  <li><b>Telepon:</b> <?= htmlspecialchars($telepon) ?></li>
  <li><b>Kepala Sekolah:</b> <?= htmlspecialchars($kepsek) ?></li>
</ul>

    </div>
  </div>

  <!-- INFORMASI SISTEM -->
  <div class="col-md-6">
    <div class="card shadow p-4">
      <h6 class="fw-bold">ℹ️ Informasi Sistem</h6>
      <ul class="mb-0 small">
        <li>Status: <span class="badge bg-success">Aktif</span></li>
        <li>Mode: CBT Online</li>
        <li>Versi: 1.0</li>
        <li>Database: <?= htmlspecialchars($table_used ?? 'Default') ?></li>
        <li>Developer: Bang Zae</li>
      </ul>
    </div>
  </div>

</div>

</div>
</div>
</form>

</div>
</div>

</div>
<!-- ===== MODAL EDIT PROFIL SEKOLAH ===== -->
<div class="modal fade" id="modalProfil" tabindex="-1">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <form method="post" enctype="multipart/form-data">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Edit Profil Sekolah</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body row g-3">

          <div class="col-md-6">
            <label class="form-label">Nama Aplikasi</label>
            <input type="text" name="nama_aplikasi" class="form-control"
              value="<?= htmlspecialchars($nama_aplikasi) ?>">
          </div>

          <div class="col-md-6">
            <label class="form-label">Nama Sekolah</label>
            <input type="text" name="nama_sekolah" class="form-control"
              value="<?= htmlspecialchars($nama_sekolah) ?>">
          </div>

          <div class="col-md-12">
            <label class="form-label">Alamat</label>
            <textarea name="alamat" class="form-control" rows="2"><?= htmlspecialchars($alamat) ?></textarea>
          </div>

          <div class="col-md-4">
            <label class="form-label">NPSN</label>
            <input type="text" name="npsn" class="form-control"
              value="<?= htmlspecialchars($npsn) ?>">
          </div>

          <div class="col-md-4">
            <label class="form-label">Telepon</label>
            <input type="text" name="telp" class="form-control"
              value="<?= htmlspecialchars($telepon) ?>">
          </div>

          <div class="col-md-4">
            <label class="form-label">Kepala Sekolah</label>
            <input type="text" name="kepala_sekolah" class="form-control"
              value="<?= htmlspecialchars($kepsek) ?>">
          </div>

          <div class="col-md-12">
            <label class="form-label">Logo Sekolah</label>
            <input type="file" name="logo" class="form-control">
            <small class="text-muted">Kosongkan jika tidak ganti logo</small>
          </div>

        </div>

        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
          <button type="submit" name="simpan_profil" class="btn btn-success">
            <i class="bi bi-save"></i> Simpan
          </button>
        </div>
      </div>
    </form>
  </div>
</div>


<!-- ===== FOOTER ===== -->
<div class="footer-fixed">
  Dibuat Oleh : <b>Bang Zae</b>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
