<?php
require __DIR__ . '/../config/database.php';
session_start();

/* ===== PROTEKSI ADMIN ===== */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

/* ===== PARAMETER ===== */
$kelas = $_GET['kelas'] ?? '';
$mapel = $_GET['mapel'] ?? '';
$siswa = (int)($_GET['siswa'] ?? 0);

/* ===== PROFIL SEKOLAH ===== */
$nama_sekolah = 'SEKOLAH';
$alamat = '';
$logo = 'default.png';

$q = mysqli_query($conn,"SHOW TABLES LIKE 'sekolah'");
if ($q && mysqli_num_rows($q)) {
    $s = mysqli_fetch_assoc(mysqli_query($conn,"SELECT * FROM sekolah LIMIT 1"));
    $nama_sekolah = $s['nama_sekolah'] ?? $nama_sekolah;
    $alamat       = $s['alamat'] ?? '';
    $logo         = $s['logo'] ?? $logo;
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ===== QUERY DINAMIS ===== */
$where = [];
if ($kelas) $where[] = "s.kelas='".mysqli_real_escape_string($conn,$kelas)."'";
if ($mapel) $where[] = "m.id='".(int)$mapel."'";
if ($siswa) $where[] = "s.id='$siswa'";

$whereSQL = $where ? "WHERE ".implode(" AND ",$where) : '';

$sql = "
SELECT
  s.id,
  s.nisn,
  s.nama,
  s.kelas,
  m.nama_mapel,
  h.nilai
FROM hasil h
JOIN siswa s ON s.id=h.id_siswa
JOIN ujian u ON u.id=h.id_ujian
LEFT JOIN mapel m ON m.id=u.id_mapel
$whereSQL
ORDER BY s.kelas, s.nama, m.nama_mapel
";

$data = mysqli_query($conn,$sql);
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Cetak Nilai</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#fff;font-size:13px}
@media print{button{display:none}}
.garis{
  border-top:3px solid #000;
  border-bottom:1px solid #000;
  height:6px;
  margin:8px 0 16px
}
th{
  background:#e9ecef !important;
  text-align:center;
  vertical-align:middle;
}
td{vertical-align:middle}
</style>
</head>
<body>

<button onclick="window.print()" class="btn btn-success mb-3">🖨 CETAK</button>

<!-- KOP DINAS -->
<table width="100%">
<tr>
<td width="90" class="text-center">
  <img src="../assets/logo/<?= htmlspecialchars($logo) ?>" width="80">
</td>
<td class="text-center">
  <h5 class="fw-bold mb-0"><?= strtoupper($nama_sekolah) ?></h5>
  <small><?= htmlspecialchars($alamat) ?></small>
</td>
</tr>
</table>
<div class="garis"></div>

<!-- INFO FILTER -->
<table class="mb-3">
<tr><td width="120">Kelas</td><td>: <?= $kelas ?: '-' ?></td></tr>
<tr><td>Mapel</td><td>: <?= $mapel ?: '-' ?></td></tr>
</table>

<!-- TABEL NILAI -->
<table class="table table-bordered">
<thead>
<tr>
  <th width="40">No</th>
  <th width="120">NISN</th>
  <th>Nama</th>
  <th width="80">Kelas</th>
  <th>Mapel</th>
  <th width="70">Nilai</th>
</tr>
</thead>
<tbody>
<?php if (!$data || mysqli_num_rows($data)==0): ?>
<tr>
<td colspan="6" class="text-center text-muted">Data tidak ditemukan</td>
</tr>
<?php else: ?>
<?php $no=1; while($r=mysqli_fetch_assoc($data)): ?>
<tr>
<td class="text-center"><?= $no++ ?></td>
<td><?= htmlspecialchars($r['nisn']) ?></td>
<td><?= htmlspecialchars($r['nama']) ?></td>
<td class="text-center"><?= htmlspecialchars($r['kelas']) ?></td>
<td><?= htmlspecialchars($r['nama_mapel'] ?? '-') ?></td>
<td class="text-center fw-bold"><?= (int)$r['nilai'] ?></td>
</tr>
<?php endwhile ?>
<?php endif ?>
</tbody>
</table>

<!-- TTD -->
<div class="text-end mt-5">
<p>Pengawas</p><br><br>
<p><b>( __________________________ )</b></p>
</div>

</body>
</html>
