<?php
require __DIR__ . '/../config/database.php';

/* ================= KONEKSI PKBM ================= */
$conn2 = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if(!$conn2){
    die("Koneksi PKBM gagal: ".mysqli_connect_error());
}

/* ================= SESSION ================= */
if (session_status() === PHP_SESSION_NONE) session_start();
if (empty($_SESSION['login'])) {
    header("Location: ../auth/login.php");
    exit;
}

$id_kelas   = isset($_GET['kelas']) ? (int)$_GET['kelas'] : 0;
$dataSiswa  = [];

/* ================= PROFIL ================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo = 'default.png';

$q = mysqli_query($conn,"SELECT * FROM sekolah LIMIT 1");
if($q && mysqli_num_rows($q)){
    $s = mysqli_fetch_assoc($q);
    $nama_sekolah = $s['nama_sekolah'] ?? $nama_sekolah;
    $logo = $s['logo'] ?? $logo;
}
if(!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= DATA KELAS ================= */
$qKelas = mysqli_query($conn2,"
    SELECT id,
           CONCAT(nama_kelas,'-',CHAR(64+paket_id)) AS nama_kelas
    FROM kelas
    ORDER BY nama_kelas, paket_id
");

/* ================= KELAS DIPILIH ================= */


if($id_kelas){
    $qs = mysqli_query($conn2,"
        SELECT id, nis, nama
        FROM siswa
        WHERE kelas_id = $id_kelas
        ORDER BY nama
    ");

    if($qs){
        while($row = mysqli_fetch_assoc($qs)){
            $dataSiswa[] = $row;
        }
    }
}


?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Cetak Kartu Ujian</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{background:#f4f6f9}
.sidebar{
    width:260px;
    min-height:100vh;
    background:#1f2937;
    color:#fff;
    position:fixed
}
.brand{
    padding:16px;
    background:#111827;
    display:flex;
    gap:12px;
    align-items:center
}
.brand img{width:36px}
.sidebar a{
    color:#cbd5e1;
    padding:10px 16px;
    display:block;
    text-decoration:none
}
.sidebar a:hover,
.sidebar a.active{
    background:#2563eb;
    color:#fff
}
.submenu a{padding-left:42px;font-size:14px}
.content{
    margin-left:260px;
    padding:24px
}
</style>
</head>

<body>

<!-- SIDEBAR -->
<div class="sidebar position-fixed">
  <div class="brand">
    <img src="../assets/logo/<?= htmlspecialchars($logo) ?>">
    <div>
      <div><?= htmlspecialchars($nama_aplikasi) ?></div>
      <small style="opacity:.7"><?= htmlspecialchars($nama_sekolah) ?></small>
    </div>
  </div>

  <a href="dashboard.php"><i class="bi bi-speedometer2 me-2"></i> Dashboard</a>

  <a data-bs-toggle="collapse" href="#master">
    <i class="bi bi-database me-2"></i> Master Data
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse submenu" id="master">
    <a href="mapel.php">📘 Mata Pelajaran</a>
    <a href="kelas.php">🏫 Kelas</a>
    <a href="siswa.php">👨‍🎓 Siswa</a>
    <a href="tahun.php">📅 Tahun Pelajaran</a>
  </div>

  <a data-bs-toggle="collapse" href="#ujian" class="active">
    <i class="bi bi-pencil-square me-2"></i> Ujian
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse show submenu" id="ujian">
    <a class="active" href="cetak_kartu_kelas.php">🖨 Cetak Kartu</a>
    <a href="paket.php">📦 Paket Ujian</a>
    <a href="ujian.php">📝 Daftar Ujian</a>
    <a href="token.php">🔑 Token</a>
  </div>

  <a data-bs-toggle="collapse" href="#hasil">
    <i class="bi bi-bar-chart-line me-2"></i> Hasil
    <i class="bi bi-chevron-down float-end"></i>
  </a>
  <div class="collapse submenu" id="hasil">
    <a href="hasil.php">📊 Nilai</a>
    <a href="ranking.php">🏆 Ranking</a>
  </div>

  <a href="../auth/logout.php">
    <i class="bi bi-box-arrow-right me-2"></i> Logout
  </a>
</div>

<!-- CONTENT -->
<div class="content">
<div class="card shadow-sm">
<div class="card-header fw-bold">
<i class="bi bi-printer"></i> Cetak Kartu Ujian
</div>

<div class="card-body">

<!-- PILIH KELAS -->
<form method="get">
<div class="mb-3">
<label class="form-label">Pilih Kelas</label>
<select name="kelas" class="form-select" onchange="this.form.submit()" required>
<option value="">-- Pilih Kelas --</option>
<?php mysqli_data_seek($qKelas,0); while($k=mysqli_fetch_assoc($qKelas)): ?>
<option value="<?= $k['id'] ?>" <?= $id_kelas==$k['id']?'selected':'' ?>>
<?= htmlspecialchars($k['nama_kelas']) ?>
</option>
<?php endwhile ?>
</select>
</div>
</form>

<?php if($id_kelas): ?>
<hr>

<form method="post" action="cetak_kartu.php" target="_blank">
<input type="hidden" name="kelas" value="<?= $id_kelas ?>">

<div class="table-responsive">
<table class="table table-bordered table-striped table-sm">
<thead class="table-dark">
<tr>
<th width="40"><input type="checkbox" onclick="toggle(this)"></th>
<th>NIS</th>
<th>Nama Siswa</th>
<th width="120">Aksi</th>
</tr>
</thead>
<tbody>

<?php if(!$dataSiswa): ?>
<tr><td colspan="4" class="text-center">Tidak ada siswa</td></tr>
<?php endif ?>

<?php foreach($dataSiswa as $s): ?>
<tr>
<td><input type="checkbox" name="siswa[]" value="<?= $s['id'] ?>"></td>
<td><?= htmlspecialchars($s['nis']) ?></td>
<td><?= htmlspecialchars($s['nama']) ?></td>
<td>
<a href="cetak_kartu.php?kelas=<?= $id_kelas ?>&siswa=<?= $s['id'] ?>"
   target="_blank"
   class="btn btn-sm btn-primary">
Cetak
</a>
</td>
</tr>
<?php endforeach ?>

</tbody>
</table>
</div>

<div class="d-flex gap-2">
<button type="submit" name="mode" value="pilihan" class="btn btn-success">
Cetak Pilihan
</button>
<button type="submit" name="mode" value="kelas" class="btn btn-primary">
Cetak Semua Kelas
</button>
</div>
</form>
<?php endif ?>

</div>
</div>
</div>

<script>
function toggle(source){
  document.querySelectorAll('input[name="siswa[]"]').forEach(cb=>{
    cb.checked = source.checked;
  });
}
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
