<?php
require __DIR__ . '/../config/database.php';
if (session_status() === PHP_SESSION_NONE) session_start();

/* ================== KONEKSI DB PKBM ================== */
$conn2 = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if(!$conn2) die("Koneksi PKBM gagal: ".mysqli_connect_error());

/* ================= PROFIL ================= */
$nama_aplikasi = 'SMART CBT';
$nama_sekolah  = 'SEKOLAH';
$logo          = 'default.png';

$q = mysqli_query($conn,"SELECT * FROM sekolah LIMIT 1");
if ($q && mysqli_num_rows($q)) {
    $s = mysqli_fetch_assoc($q);
    $nama_sekolah = $s['nama_sekolah'] ?? $nama_sekolah;
    $logo = $s['logo'] ?? $logo;
}
if (!file_exists(__DIR__."/../assets/logo/$logo")) $logo='default.png';

/* ================= FILTER ================= */
$filter_kelas = $_GET['kelas'] ?? '';
$filter_mapel = $_GET['mapel'] ?? '';
$filter_siswa = $_GET['siswa'] ?? '';

$where = [];
if($filter_kelas!='') $where[] = "u.id_kelas='$filter_kelas'";
if($filter_mapel!='') $where[] = "u.id_mapel='$filter_mapel'";
if($filter_siswa!='') $where[] = "s.id='$filter_siswa'";

$whereSQL = count($where) ? "WHERE ".implode(" AND ",$where) : "";

/* ================= QUERY ================= */
$sql = "
SELECT
    s.nisn,
    s.nama,
    CONCAT(k.nama_kelas,'-',CHAR(64+k.paket_id)) AS nama_kelas,
    m.nama_mapel,
    h.nilai,
    h.selesai
FROM smart_cbt.hasil h
JOIN pkbm_taruna_qurani.siswa s ON s.id = h.id_siswa
JOIN smart_cbt.ujian u ON u.id = h.id_ujian
JOIN pkbm_taruna_qurani.kelas k ON k.id = u.id_kelas
LEFT JOIN pkbm_taruna_qurani.mapel m ON m.id = u.id_mapel
$whereSQL
ORDER BY s.nama, m.nama_mapel
";

$data = mysqli_query($conn,$sql);
if(!$data) die("SQL Error: ".mysqli_error($conn));
?>

<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Cetak Hasil Nilai</title>
<style>
body{font-family:Arial;font-size:12px;color:#000}
.kop{display:flex;align-items:center;border-bottom:3px solid #000;padding-bottom:10px;margin-bottom:15px}
.kop img{width:70px;margin-right:15px}
.kop h3{margin:0;font-size:18px}
.kop p{margin:2px 0 0}
table{width:100%;border-collapse:collapse}
th,td{border:1px solid #000;padding:6px;text-align:center}
th{background:#eee}
.footer{margin-top:25px;text-align:right}
@media print{
    @page{size:A4 landscape;margin:15mm}
}
</style>
</head>
<body onload="window.print()">

<div class="kop">
    <img src="../assets/logo/<?= $logo ?>">
    <div>
        <h3><?= $nama_sekolah ?></h3>
        <p>Laporan Hasil Nilai Ujian</p>
    </div>
</div>

<table>
<thead>
<tr>
<th>No</th>
<th>NISN</th>
<th>Nama</th>
<th>Kelas</th>
<th>Mapel</th>
<th>Nilai</th>
<th>Selesai</th>
</tr>
</thead>
<tbody>
<?php if(mysqli_num_rows($data)==0): ?>
<tr><td colspan="7">Data kosong</td></tr>
<?php else: $no=1; while($r=mysqli_fetch_assoc($data)): ?>
<tr>
<td><?= $no++ ?></td>
<td><?= htmlspecialchars($r['nisn']) ?></td>
<td><?= htmlspecialchars($r['nama']) ?></td>
<td><?= htmlspecialchars($r['nama_kelas']) ?></td>
<td><?= htmlspecialchars($r['nama_mapel']) ?></td>
<td><b><?= (int)$r['nilai'] ?></b></td>
<td><?= $r['selesai'] ? date('d-m-Y H:i',strtotime($r['selesai'])) : '-' ?></td>
</tr>
<?php endwhile; endif ?>
</tbody>
</table>

<div class="footer">
<?= date('d F Y') ?><br>
Pengawas
<br><br><br>
( _______________________ )
</div>

</body>
</html>
