<?php
session_start();
require "koneksi.php";
date_default_timezone_set('Asia/Jakarta');
header('Content-Type: application/json');

/* ================= AUTH ================= */
if (empty($_SESSION['login_tutor']) || empty($_SESSION['tutor_id'])) {
  echo json_encode([
    'status' => 'error',
    'message' => 'Akses ditolak'
  ]);
  exit;
}

$tutor_id = (int)$_SESSION['tutor_id'];
$mode     = $_POST['mode'] ?? 'masuk'; // masuk | pulang
$alamat   = trim($_POST['alamat'] ?? '-');
$lat      = (float)($_POST['lat'] ?? 0);
$lng      = (float)($_POST['lng'] ?? 0);
$tanggal  = date('Y-m-d');
$jam      = date('H:i:s');

/* ================= VALIDASI INPUT ================= */
if (!isset($_FILES['foto'])) {
  echo json_encode([
    'status' => 'error',
    'message' => 'Foto wajib diambil'
  ]);
  exit;
}

if ($lat == 0 || $lng == 0) {
  echo json_encode([
    'status' => 'error',
    'message' => 'Lokasi tidak valid'
  ]);
  exit;
}

/* ================= CEK DATA HARI INI ================= */
$q = mysqli_prepare($conn, "
  SELECT id, waktu, waktu_pulang, foto_masuk, foto_pulang 
  FROM presensi_guru 
  WHERE tutor_id = ? 
    AND tanggal = ? 
    AND status = 'hadir'
  LIMIT 1
");
mysqli_stmt_bind_param($q, "is", $tutor_id, $tanggal);
mysqli_stmt_execute($q);
$res = mysqli_stmt_get_result($q);
$p   = $res ? mysqli_fetch_assoc($res) : null;

/* ================= VALIDASI LOGIKA ================= */
if ($mode === 'masuk') {

  if ($p) {
    echo json_encode([
      'status' => 'error',
      'message' => 'Anda sudah absen masuk hari ini'
    ]);
    exit;
  }

} else { // MODE PULANG

  if (!$p) {
    echo json_encode([
      'status' => 'error',
      'message' => 'Anda belum absen masuk hari ini'
    ]);
    exit;
  }

  if (!empty($p['waktu_pulang'])) {
    echo json_encode([
      'status' => 'error',
      'message' => 'Anda sudah absen pulang hari ini'
    ]);
    exit;
  }
}

/* ================= PROSES UPLOAD FOTO ================= */
$folder = __DIR__ . "/uploads/presensi/";
if (!is_dir($folder)) {
  mkdir($folder, 0777, true);
}

$ext = strtolower(pathinfo($_FILES['foto']['name'], PATHINFO_EXTENSION));
if (!in_array($ext, ['jpg','jpeg','png','webp'])) {
  echo json_encode([
    'status' => 'error',
    'message' => 'Format foto tidak valid'
  ]);
  exit;
}

$nama_file = $mode . '_' . $tutor_id . '_' . date('Ymd_His') . '.' . $ext;
$file_path = $folder . $nama_file;

if (!move_uploaded_file($_FILES['foto']['tmp_name'], $file_path)) {
  echo json_encode([
    'status' => 'error',
    'message' => 'Gagal menyimpan foto'
  ]);
  exit;
}

/* ================= SIMPAN DB ================= */
if ($mode === 'masuk') {

  $stmt = mysqli_prepare($conn, "
    INSERT INTO presensi_guru 
    (tutor_id, tanggal, waktu, latitude_masuk, longitude_masuk, alamat, foto_masuk, status)
    VALUES (?, ?, ?, ?, ?, ?, ?, 'hadir')
  ");

  mysqli_stmt_bind_param(
    $stmt,
    "issddss",
    $tutor_id,
    $tanggal,
    $jam,
    $lat,
    $lng,
    $alamat,
    $nama_file
  );

  if (!mysqli_stmt_execute($stmt)) {
    @unlink($file_path);
    echo json_encode([
      'status' => 'error',
      'message' => 'Gagal menyimpan absen masuk'
    ]);
    exit;
  }

  echo json_encode([
    'status' => 'ok',
    'mode'   => 'masuk',
    'jam'    => date('H:i'),
    'alamat' => $alamat
  ]);
  exit;

} else { // MODE PULANG

  $stmt = mysqli_prepare($conn, "
    UPDATE presensi_guru 
    SET 
      waktu_pulang     = ?, 
      foto_pulang      = ?,
      latitude_pulang  = ?,
      longitude_pulang = ?
    WHERE id = ?
  ");

  mysqli_stmt_bind_param(
    $stmt,
    "ssddi",
    $jam,
    $nama_file,
    $lat,
    $lng,
    $p['id']
  );

  if (!mysqli_stmt_execute($stmt)) {
    @unlink($file_path);
    echo json_encode([
      'status' => 'error',
      'message' => 'Gagal menyimpan absen pulang'
    ]);
    exit;
  }

  echo json_encode([
    'status' => 'ok',
    'mode'   => 'pulang',
    'jam'    => date('H:i'),
    'alamat' => $alamat
  ]);
  exit;
}
