<?php
session_start();
require "koneksi.php";
date_default_timezone_set('Asia/Jakarta');

/* ================= AUTH ================= */
if (empty($_SESSION['login_tutor'])) {
    header("Location: login.php");
    exit;
}

/* ================= DEFAULT PKBM ================= */
$logo = 'default.png';
$nama_sekolah = 'PKBM';

/* ================= DATA PKBM ================= */
$q_pkbm = mysqli_query($conn, "SELECT nama_sekolah, logo FROM pkbm LIMIT 1");
if ($q_pkbm && mysqli_num_rows($q_pkbm) === 1) {
    $pkbm = mysqli_fetch_assoc($q_pkbm);
    if (!empty($pkbm['logo'])) $logo = $pkbm['logo'];
    if (!empty($pkbm['nama_sekolah'])) $nama_sekolah = $pkbm['nama_sekolah'];
}

/* ================= DATA TUTOR ================= */
$tutor_id = (int)($_SESSION['tutor_id'] ?? 0);
$tanggal  = date('Y-m-d');

/* ================= PRESENSI HARI INI ================= */
$absen_masuk_text  = 'Belum Absen';
$absen_masuk_class = 'belum';
$jam_masuk   = '-';
$jam_pulang  = '-';

$foto_masuk  = '';
$foto_pulang = '';
$alamat_absen = '-';

$q_today = mysqli_query($conn, "
    SELECT waktu, waktu_pulang, foto_masuk, foto_pulang, alamat 
    FROM presensi_guru 
    WHERE tutor_id='$tutor_id' 
      AND tanggal='$tanggal'
      AND status='hadir'
    LIMIT 1
");

if ($q_today && mysqli_num_rows($q_today) === 1) {
    $p = mysqli_fetch_assoc($q_today);

    if (!empty($p['waktu'])) {
        $absen_masuk_text  = 'Sudah Absen';
        $absen_masuk_class = 'sudah';
        $jam_masuk  = substr($p['waktu'], 0, 8);
        $foto_masuk = $p['foto_masuk'] ?? '';
    }

    if (!empty($p['waktu_pulang'])) {
        $jam_pulang  = substr($p['waktu_pulang'], 0, 8);
        $foto_pulang = $p['foto_pulang'] ?? '';
    }

    if (!empty($p['alamat'])) {
        $alamat_absen = $p['alamat'];
    }
}

/* ================= RINGKASAN ================= */
$hadir = mysqli_fetch_row(mysqli_query($conn,"
    SELECT COUNT(*) 
    FROM presensi_guru 
    WHERE tutor_id='$tutor_id' 
      AND status='hadir'
"))[0] ?? 0;

$izin = mysqli_fetch_row(mysqli_query($conn,"
    SELECT COUNT(*) 
    FROM presensi_guru 
    WHERE tutor_id='$tutor_id' 
      AND status='izin'
"))[0] ?? 0;

$sakit = mysqli_fetch_row(mysqli_query($conn,"
    SELECT COUNT(*) 
    FROM presensi_guru 
    WHERE tutor_id='$tutor_id' 
      AND status='sakit'
"))[0] ?? 0;

$cuti = mysqli_fetch_row(mysqli_query($conn,"
    SELECT COUNT(*) 
    FROM presensi_guru 
    WHERE tutor_id='$tutor_id' 
      AND status='cuti'
"))[0] ?? 0;
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Dashboard Presensi</title>

<style>
body{margin:0;font-family:'Segoe UI',sans-serif;background:#f3f4f8;padding-bottom:70px}
.topbar{background:linear-gradient(135deg,#d4af37,#f6e27a);color:#222;padding:14px 16px;display:flex;align-items:center;justify-content:space-between}
.logo-wrap{display:flex;align-items:center;gap:8px}
.logo-img{height:32px;max-width:120px;object-fit:contain}
.menu{background:#fff;margin:12px;border-radius:16px;padding:15px;display:grid;grid-template-columns:repeat(5,1fr);text-align:center;box-shadow:0 8px 20px rgba(0,0,0,.08)}
.menu span{display:inline-flex;width:46px;height:46px;border-radius:12px;align-items:center;justify-content:center;color:#fff;font-size:22px;margin-bottom:6px}
.absen{background:#d4af37}.izin{background:#ffb300}.cuti{background:#6c4cff}.history{background:#2ecc71}.profil{background:#f39c12}
.status{display:grid;grid-template-columns:1fr 1fr;gap:12px;margin:12px}
.status div{border-radius:16px;padding:18px;color:#fff}
.masuk.sudah{background:#2ecc71}.masuk.belum{background:#111}.pulang{background:#7f8c8d}
.summary{display:grid;grid-template-columns:repeat(4,1fr);gap:12px;margin:12px}
.summary div{background:#fff;border-radius:14px;padding:12px;box-shadow:0 6px 15px rgba(0,0,0,.08)}
.table{background:#fff;margin:12px;border-radius:16px;box-shadow:0 8px 20px rgba(0,0,0,.08)}
.table .head,.table .row{display:grid;grid-template-columns:1fr 1fr 1fr;padding:10px;font-size:13px}
.table .head{background:#d4af37;color:#222;font-weight:600}
.popup{position:fixed;inset:0;background:rgba(0,0,0,.6);display:none;align-items:center;justify-content:center;z-index:999}
.popup-box{background:#fff;color:#000;border-radius:16px;padding:16px;width:90%;max-width:340px;text-align:center}
.popup-box img{width:100%;border-radius:12px;margin-bottom:10px}
.popup-box button{background:linear-gradient(135deg,#d4af37,#f6e27a);border:none;padding:8px 14px;border-radius:10px;font-weight:700}
.footer{position:fixed;bottom:0;left:0;right:0;background:#fff;border-top:1px solid #ddd;display:flex;justify-content:space-around;padding:6px 0}
.footer a{text-decoration:none;font-size:11px;color:#555;text-align:center}
.footer span{display:block;font-size:18px}
</style>
</head>
<body>

<!-- POPUP -->
<div class="popup" id="popup">
  <div class="popup-box">
    <h4 id="popup-title"></h4>
    <img id="popup-img" src="">
    <p id="popup-info"></p>
    <button onclick="closePopup()">Tutup</button>
  </div>
</div>

<div class="topbar">
  <span>☰</span>
  <div class="logo-wrap">
    <img src="../edu_digital/assets/img/<?= htmlspecialchars($logo) ?>" class="logo-img">
    <small><?= htmlspecialchars($nama_sekolah) ?></small>
  </div>
  <span>👤</span>
</div>

<div class="menu">
  <div onclick="location.href='presensi.php'"><span class="absen">📸</span>Absen</div>
  <div onclick="location.href='izin.php'"><span class="izin">📝</span>Izin-Cuti</div>
  <div onclick="location.href='#'"><span class="cuti">📆</span>Cuti</div>
  <div onclick="location.href='history.php'"><span class="history">📜</span>History</div>
  <div onclick="location.href='profil.php'"><span class="profil">👤</span>Profil</div>
</div>

<div class="status">
  <div class="masuk <?= $absen_masuk_class ?>">
    Absen Masuk<br><b><?= $absen_masuk_text ?></b>
  </div>
  <div class="pulang">
    Absen Pulang<br><b><?= $jam_pulang === '-' ? 'Belum Absen' : 'Sudah Absen' ?></b>
  </div>
</div>

<div class="summary">
  <div>Hadir<br><b><?= $hadir ?> Hari</b></div>
  <div>Izin<br><b><?= $izin ?> Hari</b></div>
  <div>Sakit<br><b><?= $sakit ?> Hari</b></div>
  <div>Cuti<br><b><?= $cuti ?> Hari</b></div>
</div>

<div class="table">
  <div class="head">
    <div>Tanggal</div><div>Masuk</div><div>Pulang</div>
  </div>
  <div class="row">
    <div><?= date('d/m/Y') ?></div>

    <div>
      <?php if($jam_masuk !== '-'): ?>
        <a href="javascript:void(0)" onclick="showPopup('masuk')" style="color:#d4af37;font-weight:600;text-decoration:none">
          <?= $jam_masuk ?>
        </a>
      <?php else: ?>-<?php endif; ?>
    </div>

    <div>
      <?php if($jam_pulang !== '-'): ?>
        <a href="javascript:void(0)" onclick="showPopup('pulang')" style="color:#d4af37;font-weight:600;text-decoration:none">
          <?= $jam_pulang ?>
        </a>
      <?php else: ?>-<?php endif; ?>
    </div>
  </div>
</div>

<div class="footer">
  <a><span>🏠</span>Home</a>
  <a href="presensi.php"><span>📸</span>Absensi</a>
  <a href="izin.php"><span>📝</span>Izin</a>
  <a href="history.php"><span>📜</span>History</a>
  <a href="profil.php"><span>👤</span>Profil</a>
</div>

<script>
const dataPresensi = {
  masuk: {
    jam: "<?= $jam_masuk ?>",
    foto: "<?= $foto_masuk ? 'uploads/presensi/' . rawurlencode($foto_masuk) : '' ?>",
    alamat: "<?= htmlspecialchars($alamat_absen, ENT_QUOTES) ?>"
  },
  pulang: {
    jam: "<?= $jam_pulang ?>",
    foto: "<?= $foto_pulang ? 'uploads/presensi/' . rawurlencode($foto_pulang) : '' ?>",
    alamat: "<?= htmlspecialchars($alamat_absen, ENT_QUOTES) ?>"
  }
};

function showPopup(mode){
  const p = dataPresensi[mode];

  document.getElementById("popup-title").innerText =
    mode === "masuk" ? "Absen Masuk" : "Absen Pulang";

  const img = document.getElementById("popup-img");

  if(p.foto){
    img.src = p.foto;
    img.style.display = "block";
  } else {
    img.style.display = "none";
  }

  document.getElementById("popup-info").innerHTML = `
    <b>Jam:</b> ${p.jam}<br>
    <b>Alamat:</b><br>${p.alamat}
  `;

  document.getElementById("popup").style.display = "flex";
}

function closePopup(){
  document.getElementById("popup").style.display = "none";
}
</script>

</body>
</html>
