<?php
session_start();
require "koneksi.php";

if (empty($_SESSION['login_tutor'])) {
  header("Location: login.php");
  exit;
}

$tutor_id = (int)($_SESSION['tutor_id'] ?? 0);
$success = '';
$error   = '';

/* ================= HITUNG PENDING ================= */
$pending = mysqli_fetch_row(mysqli_query($conn, "
  SELECT COUNT(*) FROM presensi_guru 
  WHERE tutor_id='$tutor_id' 
    AND status='cuti' 
    AND status_approval='pending'
"))[0] ?? 0;

/* ================= BATALKAN CUTI ================= */
if (isset($_GET['batal'])) {
  $id = (int)$_GET['batal'];

  $cek = mysqli_query($conn, "
    SELECT id FROM presensi_guru 
    WHERE id='$id' 
      AND tutor_id='$tutor_id' 
      AND status='cuti' 
      AND status_approval='pending'
    LIMIT 1
  ");

  if ($cek && mysqli_num_rows($cek) === 1) {
    mysqli_query($conn, "DELETE FROM presensi_guru WHERE id='$id'");
    $success = "Pengajuan cuti berhasil dibatalkan";
  } else {
    $error = "Cuti tidak dapat dibatalkan";
  }
}

/* ================= SIMPAN CUTI ================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

  $tgl_mulai   = $_POST['tanggal_mulai'] ?? '';
  $tgl_selesai = $_POST['tanggal_selesai'] ?? '';
  $alasan      = trim($_POST['alasan'] ?? '');

  if (!$tgl_mulai || !$tgl_selesai || !$alasan) {
    $error = "Semua field wajib diisi";
  } elseif ($tgl_selesai < $tgl_mulai) {
    $error = "Tanggal selesai tidak boleh lebih kecil dari tanggal mulai";
  } else {

    $cek = mysqli_prepare($conn, "
  SELECT id FROM presensi_guru
  WHERE tutor_id = ?
    AND tanggal_mulai <= ?
    AND tanggal_selesai >= ?
  LIMIT 1
");
mysqli_stmt_bind_param($cek, "iss", $tutor_id, $tgl_selesai, $tgl_mulai);
mysqli_stmt_execute($cek);
$res = mysqli_stmt_get_result($cek);


    if ($res && mysqli_num_rows($res) > 0) {
      $error = "Tanggal cuti bentrok dengan data presensi lain";
    } else {

      $file_surat = null;

      if (!empty($_FILES['file_surat']['name'])) {
        $folder = __DIR__ . "/uploads/surat/";
        if (!is_dir($folder)) mkdir($folder, 0777, true);

        $ext = strtolower(pathinfo($_FILES['file_surat']['name'], PATHINFO_EXTENSION));
        $allow = ['jpg','jpeg','png','pdf'];

        if (!in_array($ext, $allow)) {
          $error = "Format file harus JPG, PNG, atau PDF";
        } else {
          $file_surat = "cuti_" . $tutor_id . "_" . date('Ymd_His') . "." . $ext;
          if (!move_uploaded_file($_FILES['file_surat']['tmp_name'], $folder . $file_surat)) {
            $error = "Gagal upload file surat";
          }
        }
      }

      if (!$error) {

        mysqli_query($conn, "
          INSERT INTO presensi_guru
          (tutor_id, status, alasan, file_surat, tanggal_mulai, tanggal_selesai, status_approval)
          VALUES ('$tutor_id','cuti','$alasan','$file_surat','$tgl_mulai','$tgl_selesai','pending')
        ");

        $start = new DateTime($tgl_mulai);
        $end   = new DateTime($tgl_selesai);
        $end->modify('+1 day');

        foreach (new DatePeriod($start, new DateInterval('P1D'), $end) as $dt) {
          $tgl = $dt->format("Y-m-d");
          mysqli_query($conn, "
            INSERT INTO presensi_guru
            (tutor_id, status, tanggal, alasan, status_approval)
            VALUES ('$tutor_id','cuti','$tgl','$alasan','approved')
          ");
        }

        $success = "Pengajuan cuti berhasil dikirim";
      }
    }
  }
}

/* ================= LIST CUTI ================= */
$list = mysqli_query($conn, "
  SELECT * FROM presensi_guru
  WHERE tutor_id='$tutor_id'
    AND status='cuti'
    AND tanggal IS NULL
  ORDER BY created_at DESC
");

/* ================= DATA KALENDER ================= */
$kal = [];
$qkal = mysqli_query($conn, "
  SELECT tanggal FROM presensi_guru
  WHERE tutor_id='$tutor_id'
    AND status='cuti'
    AND tanggal IS NOT NULL
");
while($r = mysqli_fetch_assoc($qkal)){
  $kal[] = $r['tanggal'];
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Pengajuan Cuti</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<style>
body{margin:0;font-family:'Segoe UI',sans-serif;background:#f3f4f8;padding-bottom:80px}
.topbar{
  background:linear-gradient(135deg,#d4af37,#f6e27a);
  color:#222;padding:14px 16px;
  display:flex;align-items:center;justify-content:space-between
}
.badge-pending{
  background:#e74c3c;color:#fff;
  border-radius:12px;padding:4px 10px;
  font-size:12px;font-weight:700
}
.card{background:#fff;margin:12px;border-radius:16px;padding:16px;box-shadow:0 8px 20px rgba(0,0,0,.08)}
button{width:100%;padding:14px;border:none;border-radius:14px;background:linear-gradient(135deg,#f57c00,#fbc02d);color:#fff;font-size:15px;font-weight:700}
.row{background:#fff;border-radius:12px;padding:12px;box-shadow:0 6px 14px rgba(0,0,0,.08);margin-bottom:10px;font-size:13px}
.badge{padding:4px 8px;border-radius:10px;font-size:11px;font-weight:700}
.pending{background:#fff3cd;color:#856404}
.approved{background:#d4edda;color:#155724}
.btn-cancel{background:#eee;color:#333;border-radius:8px;padding:6px 10px;font-size:12px;text-decoration:none}
.popup{position:fixed;inset:0;background:rgba(0,0,0,.45);display:none;justify-content:center;align-items:center;z-index:999}
.popup-box{background:#fff;width:90%;max-width:420px;border-radius:18px;padding:18px}
input,textarea{width:100%;padding:10px;border-radius:10px;border:1px solid #ddd;margin:6px 0 12px}

/* KALENDER */
.calendar{display:grid;grid-template-columns:repeat(7,1fr);gap:6px;margin-top:10px}
.day{
  background:#f1f1f1;border-radius:8px;
  padding:10px 0;text-align:center;font-size:12px
}
.day.cuti{background:#f57c00;color:#fff;font-weight:700}
.cuti-item{
  background:#fff;
  border-radius:14px;
  box-shadow:0 4px 10px rgba(0,0,0,.08);
  padding:14px;
  margin-bottom:12px;
  font-size:13px
}
.cuti-header{
  display:flex;
  justify-content:space-between;
  margin-bottom:6px;
  font-weight:600;
}
.cuti-date{color:#444}
.status{
  padding:4px 8px;
  border-radius:10px;
  font-size:11px;
  font-weight:700;
}
.status.pending{background:#fff3cd;color:#856404}
.status.approved{background:#d4edda;color:#155724}
.status.rejected{background:#f8d7da;color:#721c24}
.status.canceled{background:#e2e3e5;color:#6c757d}

.surat-link{
  font-size:12px;
  display:inline-block;
  margin-top:4px;
  color:#007bff;
  text-decoration:none;
}
.surat-link:hover{text-decoration:underline}

.btn-cancel{
  display:inline-block;
  margin-top:6px;
  background:#eee;
  padding:6px 8px;
  border-radius:8px;
  font-size:12px;
  color:#333;
  text-decoration:none;
}
.btn-cancel:hover{background:#dcdcdc}

.footer{
  position:fixed;bottom:0;left:0;right:0;
  background:#fff;border-top:1px solid #ddd;
  display:flex;justify-content:space-around;padding:6px 0
}
.footer a{text-decoration:none;font-size:11px;color:#555;text-align:center}
.footer span{display:block;font-size:18px}
.footer a.active{color:#f57c00;font-weight:600}
</style>
</head>

<body>

<div class="topbar">
  <span>📆 Pengajuan Cuti</span>
  <?php if($pending>0): ?>
    <span class="badge-pending"><?= $pending ?> Pending</span>
  <?php endif; ?>
</div>

<div class="card">
  <button onclick="openForm()">➕ Ajukan Cuti</button>
  <?php if($success): ?><div><?= htmlspecialchars($success) ?></div><?php endif; ?>
  <?php if($error): ?><div><?= htmlspecialchars($error) ?></div><?php endif; ?>
</div>

<div class="card">
  <h4>Kalender Cuti Bulan Ini</h4>
  <div class="calendar" id="calendar"></div>
</div>

<div class="card">
  <h3>Riwayat Cuti</h3>

<?php if($list && mysqli_num_rows($list) > 0): ?>
  <?php while($r = mysqli_fetch_assoc($list)): ?>
<?php
  $dif = (new DateTime($r['tanggal_mulai']))->diff(new DateTime($r['tanggal_selesai']))->days + 1;
?>
<div class="cuti-item">
  <div class="cuti-header">
    <span class="cuti-date">
      📅 <?= $r['tanggal_mulai'] ?> — <?= $r['tanggal_selesai'] ?> (<?= $dif ?> hari)
    </span>

    <span class="status <?= $r['status_approval'] ?>">
      <?= strtoupper($r['status_approval']) ?>
    </span>
  </div>

  <div class="cuti-body">
    <div style="margin-bottom:4px"><b>Alasan:</b> <?= htmlspecialchars($r['alasan']) ?></div>

    <?php if($r['file_surat']): ?>
      <a class="surat-link" href="uploads/surat/<?= $r['file_surat'] ?>" target="_blank">📎 Lihat Surat</a>
    <?php endif; ?>

    <?php if($r['status_approval']==='pending'): ?>
      <div style="margin-top:8px">
        <a class="btn-cancel" href="?batal=<?= $r['id'] ?>" onclick="return confirm('Batalkan pengajuan ini?')">❌ Batalkan</a>
      </div>
    <?php endif; ?>
  </div>
</div>
<?php endwhile; ?>
<?php endif; ?>

<!-- POPUP FORM -->
<div id="popupForm" class="popup">
  <div class="popup-box">
    <h3>Form Cuti</h3>

    <form method="post" enctype="multipart/form-data">
      <label>Tanggal Mulai</label>
      <input type="date" name="tanggal_mulai" required>

      <label>Tanggal Selesai</label>
      <input type="date" name="tanggal_selesai" required>

      <label>Alasan</label>
      <textarea name="alasan" rows="3" required></textarea>

      <label>Upload Surat (opsional)</label>
      <input type="file" name="file_surat" accept=".jpg,.jpeg,.png,.pdf">

      <button type="submit">📤 Kirim</button>
      <button type="button" style="background:#eee;color:#333;margin-top:8px" onclick="closeForm()">✖ Tutup</button>
    </form>
  </div>
</div>

<!-- FOOTER -->
<div class="footer">
  <a href="dashboard.php"><span>🏠</span>Home</a>
  <a href="presensi.php"><span>📸</span>Presensi</a>
  <a href="izin.php"><span>📝</span>Izin</a>
  <a class="active"><span>📆</span>Cuti</a>
  <a href="profil.php"><span>👤</span>Profil</a>
</div>

<script>
const cutiDates = <?= json_encode($kal) ?>;
const cal = document.getElementById("calendar");

const now = new Date();
const y = now.getFullYear();
const m = now.getMonth();

const last = new Date(y, m + 1, 0).getDate();

for(let i=1;i<=last;i++){
  const d = new Date(y, m, i);
  const iso = d.toISOString().slice(0,10);

  const div = document.createElement("div");
  div.className = "day";
  if(cutiDates.includes(iso)) div.classList.add("cuti");

  div.innerText = i;
  cal.appendChild(div);
}

function openForm(){ document.getElementById("popupForm").style.display="flex"; }
function closeForm(){ document.getElementById("popupForm").style.display="none"; }
</script>

</body>
</html>
