<?php
session_start();

// koneksi database
$conn = mysqli_connect("localhost","root","","pkbm_taruna_qurani");
if (!$conn) die("Koneksi gagal: ".mysqli_connect_error());


// Ambil semua tutor untuk filter
$tutorList = mysqli_query($conn,"SELECT id, nama FROM users WHERE role='tutor' ORDER BY nama");

// Ambil semua kelas untuk dropdown, JOIN paket
$kelasList = mysqli_query($conn,"
    SELECT k.id, k.nama_kelas, p.nama AS paket
    FROM kelas k
    LEFT JOIN paket p ON k.paket_id = p.id
    ORDER BY k.nama_kelas
");

// Cek filter
$filterTutor = $_GET['tutor_id'] ?? '';

// Ambil jadwal guru, JOIN kelas dan paket
$sql = "
    SELECT j.*, u.nama AS tutor, k.nama_kelas, p.nama AS paket, m.nama_mapel
    FROM jadwal j
    JOIN users u ON j.tutor_id = u.id
    JOIN kelas k ON j.kelas_id = k.id
    LEFT JOIN paket p ON k.paket_id = p.id
    JOIN mapel m ON j.mapel_id = m.id
";

if($filterTutor){
    $sql .= " WHERE j.tutor_id = '".intval($filterTutor)."' ";
}

$sql .= " ORDER BY u.nama, FIELD(j.hari,'Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'), j.jam_mulai ";

$q = mysqli_query($conn, $sql);

// Grupkan per tutor
$jadwalPerTutor = [];
while($r = mysqli_fetch_assoc($q)){
    $jadwalPerTutor[$r['tutor']][] = $r;
}

// ================= DEFAULT =================
$logoSekolah = '/pkbm-test/edu_digital/assets/img/logo.png';
$namaSekolah = 'PKBM TARUNA QURANI';

// ================= AMBIL DATA PKBM =================
$q = mysqli_query($conn,"SELECT logo, nama_sekolah FROM pkbm LIMIT 1");
if($q && mysqli_num_rows($q) > 0){
    $s = mysqli_fetch_assoc($q);

    // LOGO
    if(!empty($s['logo'])){
        $fileServer = __DIR__ . '/../edu_digital/assets/img/' . $s['logo'];
        if(is_file($fileServer)){
            $logoSekolah = '/pkbm-test/edu_digital/assets/img/' . $s['logo'];
        }
    }

    // NAMA SEKOLAH
    if(!empty(trim($s['nama_sekolah']))){
        $namaSekolah = htmlspecialchars($s['nama_sekolah']);
    }
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Jadwal Guru</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{
  min-height:100vh;
  font-family:'Segoe UI',sans-serif;
  padding-bottom:70px;

  background:
    radial-gradient(circle at 20% 0%, #0d6efd22, transparent 35%),
    radial-gradient(circle at 80% 0%, #6610f222, transparent 35%),
    linear-gradient(180deg,#f9fbff,#eef2f7 60%,#f4f6f9);
}

.card{border-radius:12px; box-shadow:0 6px 18px rgba(0,0,0,.08);}
.table th, .table td{vertical-align:middle; text-align:center;}
.table th{font-weight:600;}
.btn-back{margin-bottom:20px;}
/* ===== BOTTOM NAV ===== */
.bottom{
  position: fixed;
  bottom: 0;
  left: 0;
  width: 100%;
  height: 56px;
  background: #0b1c2d;
  display: flex;
  justify-content: space-around;
  align-items: center;
  color: #fff;
  z-index: 1050;
  font-size: 14px;
}
.bottom a{
  color: #fff;
  text-decoration: none;
  display: flex;
  flex-direction: column;
  align-items: center;
  font-size: 12px;
  transition: 0.2s;
}
.bottom a i{
  font-size: 18px;
  margin-bottom: 2px;
}
.bottom a:hover{
  color: #0d6efd;
}
/* ===== TOPBAR PRO ===== */
.topbar{
  position:sticky;
  top:0;
  z-index:1100;
  background:linear-gradient(45deg,#0b1c2d,#0d6efd);
  padding:10px 0;
  box-shadow:0 4px 14px rgba(0,0,0,.18);
}

.topbar .container-fluid{
  min-height:52px;
}

.topbar-logo{
  height:38px;
  width:auto;
  object-fit:contain;
}

.topbar-title{
  color:#fff;
  font-weight:600;
  font-size:1rem;
  line-height:1.1;
  white-space:nowrap;
}

/* JUDUL HALAMAN */
.page-title{
  margin-top:15px;
  text-align:center;
  font-weight:700;
  color:#0b1c2d;
}

/* RESPONSIVE */
@media(max-width:576px){
  .topbar{
    padding:8px 0;
  }



  .topbar-title{
    font-size:.9rem;
  }
}

/* beri ruang supaya tabel tidak tertutup bottom nav */
.main-content{padding-bottom: 70px;margin-top: 40px;}
</style>
</head>
<body>
  <!-- TOPBAR -->
<div class="topbar">
  <div class="container-fluid px-4 d-flex align-items-center justify-content-between">

    <div class="d-flex align-items-center gap-2">
      <img src="<?= $logoSekolah ?>" class="topbar-logo">
      <span class="topbar-title"><?= $namaSekolah ?></span>
    </div>

  </div>
</div>

<h3 class="page-title">📅 Jadwal Guru</h3>


<!-- Filter guru di atas tabel -->
<div class="mb-3">
<form method="get" class="d-flex align-items-center gap-2 flex-wrap">
<label for="tutor_id" class="fw-bold"></label>
<select name="tutor_id" id="tutor_id" class="form-select" style="width:auto;">
    <option value="">-- Semua Guru --</option>
    <?php while($t=mysqli_fetch_assoc($tutorList)): ?>
        <option value="<?= $t['id'] ?>" <?= ($filterTutor==$t['id'])?'selected':'' ?>><?= htmlspecialchars($t['nama']) ?></option>
    <?php endwhile; ?>
</select>
<button class="btn btn-primary btn-sm">Tampilkan</button>
</form>
</div>

<div class="card p-3">
<div class="table-responsive">
<table class="table table-bordered table-hover align-middle">
<thead class="table-dark">
<tr>
<th>Tutor</th>
<th>Kelas</th>
<th>Mapel</th>
<th>Hari</th>
<th>Jam</th>
</tr>
</thead>
<tbody>
<?php
if(empty($jadwalPerTutor)){
    echo '<tr><td colspan="5" class="text-center text-muted">Belum ada jadwal</td></tr>';
} else {
    foreach($jadwalPerTutor as $tutor => $jadwals){
        $rowspan = count($jadwals);
        $first = true;
        foreach($jadwals as $j){
            echo "<tr>";
            if($first){
                echo "<td rowspan='$rowspan'>$tutor</td>";
                $first = false;
            }
            // Tampilkan kelas + paket
            $kelasFull = $j['nama_kelas'] . ($j['paket'] ? ' - '.$j['paket'] : '');
            echo "<td>$kelasFull</td>";
            echo "<td>{$j['nama_mapel']}</td>";
            echo "<td>{$j['hari']}</td>";
            echo "<td>{$j['jam_mulai']} - {$j['jam_selesai']}</td>";
            echo "</tr>";
        }
    }
}
?>
</tbody>
</table>
</div>
</div>
</div>

<!-- ===== BOTTOM NAV ===== -->
<div class="bottom">
   <a href="/pkbm-test/index.html"><i class="bi bi-house"></i>Home</a>
  <a href=/pkbm-test/ebook_guru.php><i class="bi bi-book"></i>E-Book</a>
  <a href="#"><i class="bi bi-chat"></i>Chat</a>
  <a href="#"><i class="bi bi-person"></i>Profil</a>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
