<?php
session_start();
require '../../config/database.php';

date_default_timezone_set('Asia/Jakarta');

/* ================= CEK LOGIN ================= */
if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'tutor'
){
    header("Location: ../../auth/login.php");
    exit;
}

$tutor_id   = (int)($_SESSION['user']['id'] ?? 0);
$nama_tutor = $_SESSION['user']['nama'] ?? 'Tutor';

/* ================= CEK ID ================= */
$id = (int)($_GET['id'] ?? 0);
if($id <= 0){
    die("ID meeting tidak valid.");
}

/* ================= AMBIL DATA MEETING (SATU KALI) ================= */
$q = mysqli_query($conn,"
SELECT 
    z.*,
    k.nama_kelas,
    m.nama_mapel
FROM zoom_meeting z
JOIN kelas k ON z.kelas_id = k.id
LEFT JOIN mapel m ON z.mapel_id = m.id
WHERE z.id='$id'
AND z.tutor_id='$tutor_id'
LIMIT 1
");

$data = mysqli_fetch_assoc($q);
if(!$data){
    die("Data meeting tidak ditemukan atau bukan milik Anda.");
}

/* ================= AUTO UPDATE STATUS ================= */
mysqli_query($conn,"
UPDATE zoom_meeting
SET status='live'
WHERE id='$id'
AND NOW() BETWEEN waktu_mulai AND waktu_selesai
");

mysqli_query($conn,"
UPDATE zoom_meeting
SET status='selesai'
WHERE id='$id'
AND NOW() > waktu_selesai
");

/* ================= DATA SIAP PAKAI ================= */
$nama_kelas   = $data['nama_kelas'];
$nama_mapel   = $data['nama_mapel'];
$waktu_mulai  = $data['waktu_mulai'];
$status       = $data['status'];

/* ================= ROOM NAME ================= */
$kelas = preg_replace('/[^A-Za-z0-9\-]/', '', $nama_kelas);
$mapel = preg_replace('/[^A-Za-z0-9]/', '', $nama_mapel);
$roomName = "PKBM_{$kelas}_{$mapel}_{$id}";

/* ================= WAKTU ================= */
$mulai   = strtotime($waktu_mulai);
$now     = time();
$selisih = max(0, $mulai - $now);

/* ================= DATA HADIR ================= */
$hadir = mysqli_query($conn,"
SELECT s.nama
FROM presensi_zoom p
JOIN siswa s ON p.siswa_id = s.id
WHERE p.zoom_id='$id'
AND p.tanggal = CURDATE()
ORDER BY s.nama ASC
");
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Live Kelas <?= htmlspecialchars($nama_kelas) ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<script src="https://meet.jit.si/external_api.js"></script>

<style>
body{margin:0;font-family:Arial;background:#0f172a;color:white;}
.header{background:#111827;padding:15px;display:flex;justify-content:space-between;align-items:center;}
.badge-live{background:#dc3545;padding:5px 10px;border-radius:20px;}
.badge-wait{background:orange;padding:5px 10px;border-radius:20px;}
#jitsi-container{width:75%;height:90vh;float:left;}
.sidebar{width:25%;height:90vh;float:right;background:#1e293b;padding:15px;overflow:auto;}
</style>
</head>
<body>

<div class="header">
<div>
<strong><?= htmlspecialchars($nama_mapel) ?></strong> |
Kelas <?= htmlspecialchars($nama_kelas) ?>
</div>
<div id="countdown"></div>
</div>

<div id="jitsi-container"></div>

<script>
let selisih = <?= $selisih ?>;
const countdownEl = document.getElementById("countdown");

/* LOAD JITSI SEKALI */
const api = new JitsiMeetExternalAPI("meet.jit.si", {
    roomName: "<?= $roomName ?>",
    parentNode: document.querySelector('#jitsi-container'),
    width: "100%",
    height: "100%",
    userInfo: { displayName: "<?= htmlspecialchars($nama_tutor) ?>" },
    configOverwrite: {
        startWithAudioMuted: true,
        startWithVideoMuted: true,
        enableWelcomePage: false
    }
});

if(selisih > 0){
    countdownEl.innerHTML = "<span class='badge-wait'>Menunggu mulai...</span>";
    const timer = setInterval(()=>{
        selisih--;
        countdownEl.innerHTML = "Mulai dalam " +
            Math.floor(selisih/60) + "m " + (selisih%60) + "s";
        if(selisih <= 0){
            clearInterval(timer);
            api.executeCommand('toggleAudio');
            api.executeCommand('toggleVideo');
            countdownEl.innerHTML = "<span class='badge-live'>LIVE</span>";
        }
    },1000);
}else{
    api.executeCommand('toggleAudio');
    api.executeCommand('toggleVideo');
    countdownEl.innerHTML = "<span class='badge-live'>LIVE</span>";
}
</script>

</body>
</html>
