<?php  
require '../config/database.php';

$materi_id = (int)($_GET['materi_id'] ?? 0);

$q = mysqli_query($conn, "
  SELECT * FROM materi_soal 
  WHERE materi_id = $materi_id 
  ORDER BY urutan ASC, id ASC
");

$no = 1;

if (!mysqli_num_rows($q)) {
    echo "<div class='text-muted text-center'>Belum ada soal</div>";
    exit;
}
?>

<!-- ================= MODAL EDIT SOAL ================= -->
<div class="modal fade" id="modalEditSoal" tabindex="-1">
<div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
<div class="modal-content">

<div class="modal-header bg-warning">
<h5 class="modal-title">✏️ Edit Soal</h5>
<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
</div>

<form method="post" action="soal_edit_proses.php">

<div class="modal-body" id="isi-modal-edit">
<!-- FORM EDIT AJAX -->
</div>

<div class="modal-footer">
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
<button type="submit" class="btn btn-primary">💾 Simpan Perubahan</button>
</div>

</form>
</div>
</div>
</div>

<?php
while ($s = mysqli_fetch_assoc($q)) {

  $opsi = [];
  $jawaban_benar = '';

  $qo = mysqli_query($conn, "
    SELECT * FROM materi_soal_opsi 
    WHERE soal_id = {$s['id']}
    ORDER BY id ASC
  ");

  $huruf = ['A','B','C','D','E'];
  $i = 0;

  while ($o = mysqli_fetch_assoc($qo)) {

    if ($s['tipe'] == 'pg') {
      $o['huruf'] = $huruf[$i] ?? '';
    } else {
      $o['huruf'] = '';
    }

    if ($o['benar'] == 1) {
      if ($s['tipe'] == 'pg') {
        $jawaban_benar = $o['huruf'] . '. ' . $o['opsi'];
      } else {
        $jawaban_benar = $o['opsi'];
      }
    }

    $opsi[] = $o;
    $i++;
  }

  if ($s['tipe'] == 'pg')      $badge = "<span class='badge bg-primary ms-2'>PG</span>";
  elseif ($s['tipe'] == 'bs')  $badge = "<span class='badge bg-warning text-dark ms-2'>BS</span>";
  elseif ($s['tipe'] == 'isian') $badge = "<span class='badge bg-info ms-2'>ISIAN</span>";
  else                        $badge = "<span class='badge bg-secondary ms-2'>ESSAY</span>";
?>

<div class="card shadow-sm mb-3 position-relative">
<div class="card-body">
<div class="row">

<!-- KIRI -->
<div class="col-md-8">

<b><?= $no ?>. <?= htmlspecialchars($s['pertanyaan']) ?></b>
<?= $badge ?>

<hr class="my-2">

<?php if ($s['tipe'] == 'pg' || $s['tipe'] == 'bs'): ?>

<ul class="list-group list-group-flush">
<?php foreach ($opsi as $o): ?>
<li class="list-group-item">
<?php if ($o['benar']): ?>
  <b class="text-success">
    ✔ <?= $s['tipe']=='pg' ? $o['huruf'].'. ' : '' ?>
    <?= htmlspecialchars($o['opsi']) ?>
  </b>
<?php else: ?>
    <?= $s['tipe']=='pg' ? $o['huruf'].'. ' : '' ?>
    <?= htmlspecialchars($o['opsi']) ?>
<?php endif; ?>
</li>
<?php endforeach; ?>
</ul>

<?php elseif ($s['tipe'] == 'isian'): ?>

<div class="alert alert-light">
<b>Jawaban Isian:</b><br>
<?= $jawaban_benar 
  ? '<span class="text-success fw-bold">'.htmlspecialchars($jawaban_benar).'</span>' 
  : '<span class="text-muted">Belum ada kunci jawaban</span>' ?>
</div>

<?php else: ?>

<div class="alert alert-light">
<b>Kunci Essay:</b><br>
<?= $jawaban_benar 
  ? '<span class="text-success fw-bold">'.htmlspecialchars($jawaban_benar).'</span>' 
  : '<span class="text-warning">Dinilai manual</span>' ?>
</div>

<?php endif; ?>

</div>

<!-- KANAN -->
<div class="col-md-4 border-start">

<b>Jawaban Benar</b>
<div class="alert alert-success mt-2 mb-3">
<?= $jawaban_benar ? htmlspecialchars($jawaban_benar) : "<i>Dinilai manual</i>" ?>
</div>

<div class="d-flex gap-2">

<!-- 🔥 TOMBOL EDIT SUPER AMAN -->
<button 
  type="button"
  class="btn btn-warning btn-sm"
  style="position:relative; z-index:10;"
  onclick="editSoal(<?= $s['id'] ?>)">
<i class="bi bi-pencil"></i> Edit
</button>

<a href="soal_hapus.php?id=<?= $s['id'] ?>&materi_id=<?= $materi_id ?>" 
   class="btn btn-danger btn-sm"
   onclick="return confirm('Hapus soal ini?')">
<i class="bi bi-trash"></i>
</a>

</div>

</div>

</div>
</div>
</div>

<?php 
$no++;
} 
?>

<!-- ================= SCRIPT EDIT (FINAL PALING STABIL) ================= -->
<script>
function editSoal(id){

  console.log("EDIT SOAL ID:", id); // 🔍 DEBUG

  fetch("soal_edit_form.php?id=" + id)
    .then(res => res.text())
    .then(html => {

      document.getElementById("isi-modal-edit").innerHTML = html;

      var modal = new bootstrap.Modal(
        document.getElementById("modalEditSoal")
      );

      modal.show();
    });
}
</script>
