<?php
session_start();
require '../config/database.php';

/* ================= SECURITY ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'tutor') {
    die('Akses ditolak');
}

$tutor_id = (int)($_SESSION['user']['id'] ?? 0);
$aksi     = $_POST['aksi'] ?? $_GET['aksi'] ?? '';

/* ================= TAHUN AJARAN AKTIF ================= */
$qta = mysqli_query($conn,"SELECT id FROM tahun_ajaran WHERE status='aktif' LIMIT 1");
$tahun = mysqli_fetch_assoc($qta);
if(!$tahun){
    die('Tahun ajaran aktif belum diset');
}
$tahun_id = (int)$tahun['id'];

/* ================= FUNGSI UPLOAD FILE ================= */
function upload_file(array $file, string $tipe): string
{
    if ($file['error'] !== UPLOAD_ERR_OK) {
        die('Upload file gagal');
    }

    $allowed = [
        'pdf'   => ['pdf'],
        'video' => ['mp4','mpeg','webm']
    ];

    if (!isset($allowed[$tipe])) {
        die('Tipe materi tidak valid');
    }

    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    if (!in_array($ext, $allowed[$tipe])) {
        die('Format file tidak diizinkan');
    }

    $nama_baru = time() . '_' . bin2hex(random_bytes(3)) . '.' . $ext;
    $folder    = "../materi_upload/$tipe/";

    if (!is_dir($folder)) {
        mkdir($folder, 0755, true);
    }

    if (!move_uploaded_file($file['tmp_name'], $folder . $nama_baru)) {
        die('Gagal menyimpan file');
    }

    return $nama_baru;
}

/* ================= TAMBAH MATERI ================= */
if ($aksi === 'tambah') {

    $judul    = trim($_POST['judul'] ?? '');
    $mapel_id = (int)($_POST['mapel_id'] ?? 0);
    $tipe     = $_POST['tipe'] ?? '';
    $kelas    = $_POST['kelas'] ?? [];

    if (!$judul || !$mapel_id || !in_array($tipe,['pdf','video']) || empty($kelas)) {
        die('Data belum lengkap');
    }

    if (empty($_FILES['file']['name'])) {
        die('File belum dipilih');
    }

    $judul = mysqli_real_escape_string($conn, $judul);
    $file  = upload_file($_FILES['file'], $tipe);

    mysqli_query($conn,"
        INSERT INTO materi (tutor_id,mapel_id,judul,tipe,file,created_at)
        VALUES ('$tutor_id','$mapel_id','$judul','$tipe','$file',NOW())
    ");

    $materi_id = mysqli_insert_id($conn);

    foreach ($kelas as $k) {
        $k = (int)$k;
        mysqli_query($conn,"
            INSERT INTO materi_kelas (materi_id,kelas_id)
            VALUES ('$materi_id','$k')
        ");
    }

    header("Location: materi.php");
    exit;
}

/* ================= EDIT MATERI ================= */
if ($aksi === 'edit') {

    $id       = (int)($_POST['id'] ?? 0);
    $judul    = trim($_POST['judul'] ?? '');
    $mapel_id = (int)($_POST['mapel_id'] ?? 0);
    $tipe     = $_POST['tipe'] ?? '';
    $kelas    = $_POST['kelas'] ?? [];

    if (!$id || !$judul || !$mapel_id || !in_array($tipe,['pdf','video']) || empty($kelas)) {
        die('Data tidak lengkap');
    }

    $judul = mysqli_real_escape_string($conn, $judul);

    $q = mysqli_query($conn,"
        SELECT * FROM materi
        WHERE id='$id' AND tutor_id='$tutor_id'
    ");
    $m = mysqli_fetch_assoc($q);
    if (!$m) {
        die('Materi tidak valid');
    }

    $file = $m['file'];

    if (!empty($_FILES['file']['name'])) {
        $file_baru = upload_file($_FILES['file'], $tipe);

        if ($file_baru) {
            $old = "../materi_upload/".$m['tipe']."/".$m['file'];
            if ($m['file'] && file_exists($old)) {
                unlink($old);
            }
            $file = $file_baru;
        }
    }

    mysqli_query($conn,"
        UPDATE materi SET
            judul='$judul',
            mapel_id='$mapel_id',
            tipe='$tipe',
            file='$file'
        WHERE id='$id'
    ");

    mysqli_query($conn,"DELETE FROM materi_kelas WHERE materi_id='$id'");

    foreach ($kelas as $k) {
        $k = (int)$k;
        mysqli_query($conn,"
            INSERT INTO materi_kelas (materi_id,kelas_id)
            VALUES ('$id','$k')
        ");
    }

    header("Location: materi.php");
    exit;
}

/* ================= HAPUS MATERI ================= */
if ($aksi === 'hapus') {

    $id = (int)($_POST['id'] ?? $_GET['id'] ?? 0);
    if (!$id) {
        die('ID tidak valid');
    }

    $q = mysqli_query($conn,"
        SELECT * FROM materi
        WHERE id='$id' AND tutor_id='$tutor_id'
    ");
    $m = mysqli_fetch_assoc($q);
    if (!$m) {
        die('Materi tidak ditemukan');
    }

    $file = "../materi_upload/".$m['tipe']."/".$m['file'];
    if ($m['file'] && file_exists($file)) {
        unlink($file);
    }

    mysqli_query($conn,"DELETE FROM materi_kelas WHERE materi_id='$id'");
    mysqli_query($conn,"DELETE FROM materi WHERE id='$id'");

    header("Location: materi.php");
    exit;
}

/* ================= DEFAULT ================= */
die('Aksi tidak dikenal');
