<?php
session_start();
require '../config/database.php';

/* ================= SECURITY ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'tutor') {
    http_response_code(403);
    exit(json_encode(['error' => 'Akses ditolak']));
}

$tutor_id = (int)($_SESSION['user']['id'] ?? 0);
$id       = (int)($_GET['id'] ?? 0);

if (!$id) {
    http_response_code(400);
    exit(json_encode(['error' => 'ID tidak valid']));
}

/* ================= GET MATERI ================= */
$q = mysqli_query($conn,"
    SELECT id, judul, mapel_id, tipe
    FROM materi
    WHERE id='$id' AND tutor_id='$tutor_id'
    LIMIT 1
");

$d = mysqli_fetch_assoc($q);
if (!$d) {
    http_response_code(404);
    exit(json_encode(['error' => 'Materi tidak ditemukan']));
}

/* ================= GET KELAS ================= */
$qk = mysqli_query($conn,"
    SELECT kelas_id
    FROM materi_kelas
    WHERE materi_id='$id'
");

$kelas = [];
while ($k = mysqli_fetch_assoc($qk)) {
    $kelas[] = (int)$k['kelas_id'];
}

/* ================= OUTPUT JSON ================= */
header('Content-Type: application/json; charset=utf-8');

echo json_encode([
    'id'       => (int)$d['id'],
    'judul'    => $d['judul'],
    'mapel_id' => (int)$d['mapel_id'],
    'tipe'     => $d['tipe'],
    'kelas'    => $kelas
]);
