<?php
session_start();
require '../config/database.php';

/* ================= SECURITY ================= */
if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'tutor'
) {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= DATA USER ================= */
$tutor_id = (int)$_SESSION['user']['id'];
$nama     = $_SESSION['user']['nama'];

/* ================= TAHUN AJARAN AKTIF ================= */
$qta = mysqli_query($conn,"
 SELECT id, tahun
 FROM tahun_ajaran
 WHERE status='aktif'
 LIMIT 1
");
$tahun = mysqli_fetch_assoc($qta);
if(!$tahun) die('Tahun ajaran aktif belum diset');

$tahun_id   = (int)$tahun['id'];
$tahun_nama = $tahun['tahun'];

/* ================= PROSES SIMPAN ================= */
if(isset($_POST['simpan'])){
    $mapel_id = (int)$_POST['mapel_id'];
    $kelas_id = $_POST['kelas_id'] ?? [];

    // hapus dulu agar sinkron
    mysqli_query($conn,"
     DELETE FROM kelas_mengajar
     WHERE tutor_id=$tutor_id
     AND mapel_id=$mapel_id
     AND tahun_id=$tahun_id
    ");

    foreach($kelas_id as $kid){
        $kid = (int)$kid;
        mysqli_query($conn,"
         INSERT IGNORE INTO kelas_mengajar
         (tutor_id,mapel_id,kelas_id,tahun_id)
         VALUES ($tutor_id,$mapel_id,$kid,$tahun_id)
        ");
    }

    header("Location: kelas_mengajar.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Kelas Mengajar</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{background:#f4f6f9;font-size:14px}
.main-content{margin-left:260px;padding:80px 20px}
@media(max-width:991px){.main-content{margin-left:0;padding-top:70px}}
.topbar{
 position:fixed;top:0;left:260px;right:0;height:56px;
 background:#fff;border-bottom:1px solid #ddd;
 z-index:1020;display:flex;align-items:center;padding:0 16px
}
@media(max-width:991px){.topbar{left:0}}
.card-custom{
 background:#fff;border-radius:18px;
 box-shadow:0 8px 20px rgba(0,0,0,.08)
}
</style>
</head>

<body>

<!-- TOPBAR -->
<div class="topbar">
<button class="btn btn-outline-primary d-lg-none"
 data-bs-toggle="offcanvas"
 data-bs-target="#sidebarTutor">
 <i class="bi bi-list"></i>
</button>
<span class="fw-semibold ms-2">
Kelas Mengajar
<small class="text-muted">(<?= $tahun_nama ?>)</small>
</span>
<span class="ms-auto small"><?= htmlspecialchars($nama) ?></span>
</div>

<?php include 'sidebar.php'; ?>

<div class="main-content container-fluid">
<div class="card-custom p-4">

<h6 class="mb-3">
<i class="bi bi-easel"></i> Pengaturan Kelas yang Saya Ajar
</h6>

<form method="post">
<div class="row g-3">

<div class="col-md-4">
<label class="form-label">Mapel</label>
<select name="mapel_id" class="form-select" required onchange="this.form.submit()">
<option value="">- pilih mapel -</option>
<?php
$mapel = mysqli_query($conn,"SELECT * FROM mapel ORDER BY nama_mapel");
$mapel_id = $_POST['mapel_id'] ?? 0;
while($m=mysqli_fetch_assoc($mapel)){
 $s = $mapel_id==$m['id']?'selected':'';
 echo "<option value='$m[id]' $s>$m[nama_mapel]</option>";
}
?>
</select>
</div>

<?php if($mapel_id){ ?>
<div class="col-md-8">
<label class="form-label">Kelas (<?= $tahun_nama ?>)</label>
<div class="border rounded p-3" style="max-height:240px;overflow:auto">

<?php
$qkelas = mysqli_query($conn,"
 SELECT k.id, k.nama_kelas,
 IF(km.id IS NULL,0,1) AS aktif
 FROM kelas k
 LEFT JOIN kelas_mengajar km
  ON km.kelas_id=k.id
  AND km.tutor_id=$tutor_id
  AND km.mapel_id=$mapel_id
  AND km.tahun_id=$tahun_id
 WHERE k.tahun_id=$tahun_id
 ORDER BY k.nama_kelas
");
while($k=mysqli_fetch_assoc($qkelas)){
 $ck = $k['aktif']?'checked':'';
 echo "
 <div class='form-check'>
  <input class='form-check-input'
   type='checkbox'
   name='kelas_id[]'
   value='$k[id]' $ck>
  <label class='form-check-label'>$k[nama_kelas]</label>
 </div>
 ";
}
?>

</div>
</div>
<?php } ?>

</div>

<?php if($mapel_id){ ?>
<div class="mt-3 text-end">
<button name="simpan" class="btn btn-primary btn-sm">
<i class="bi bi-save"></i> Simpan
</button>
</div>
<?php } ?>

</form>

</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
