<?php
session_start();
require '../config/database.php';

/* ================= SECURITY TUTOR ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'tutor') {
    header('Location: ../auth/login.php');
    exit;
}

$tutor_id  = (int)$_SESSION['user']['id'];
$materi_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

/* ================= VALIDASI MATERI ================= */
$qm = mysqli_query($conn,"
 SELECT m.id,m.judul,m.tipe,mp.nama_mapel
 FROM materi m
 LEFT JOIN mapel mp ON mp.id=m.mapel_id
 WHERE m.id=$materi_id AND m.tutor_id=$tutor_id
 LIMIT 1
");
$materi = mysqli_fetch_assoc($qm);
if(!$materi){ die('Materi tidak ditemukan'); }

/* ================= TAHUN AKTIF ================= */
$qta = mysqli_query($conn,"SELECT id,tahun FROM tahun_ajaran WHERE status='aktif' LIMIT 1");
$tahun = mysqli_fetch_assoc($qta);
if(!$tahun){ die('Tahun ajaran belum aktif'); }
$tahun_id = (int)$tahun['id'];

/* ================= DATA SISWA ================= */
$q = mysqli_query($conn,"
 SELECT s.id,s.nama,k.nama_kelas,
        mb.dibaca_pada
 FROM siswa s
 JOIN kelas k ON k.id=s.kelas_id
 JOIN materi_kelas mk ON mk.kelas_id=k.id
 LEFT JOIN materi_baca mb 
   ON mb.materi_id=$materi_id AND mb.siswa_id=s.id
 WHERE mk.materi_id=$materi_id AND k.tahun_id=$tahun_id
 ORDER BY k.nama_kelas,s.nama
");
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Detail E-Learning</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{background:#f4f6f9;font-size:14px}
.main-content{margin-left:260px;padding:80px 20px}
@media(max-width:991px){.main-content{margin-left:0;padding-top:70px}}
.card{border-radius:18px;box-shadow:0 6px 18px rgba(0,0,0,.08)}
</style>
</head>
<body>

<?php include 'sidebar.php'; ?>

<div class="main-content container-fluid">
<div class="card p-4">

<div class="mb-3">
<a href="elearning.php" class="btn btn-outline-secondary btn-sm">
<i class="bi bi-arrow-left"></i> Kembali
</a>
</div>

<h6 class="mb-1"><?= htmlspecialchars($materi['judul']) ?></h6>
<small class="text-muted">Mapel: <?= htmlspecialchars($materi['nama_mapel']) ?> | Tipe: <?= strtoupper($materi['tipe']) ?></small>

<hr>

<div class="table-responsive">
<table class="table table-bordered table-hover align-middle small">
<thead class="table-dark text-center">
<tr>
<th>No</th>
<th>Nama Siswa</th>
<th>Kelas</th>
<th>Status</th>
<th>Waktu Baca</th>
</tr>
</thead>
<tbody>

<?php
$no=1;
if(!mysqli_num_rows($q)):
?>
<tr><td colspan="5" class="text-center text-muted">Tidak ada siswa</td></tr>
<?php endif; ?>

<?php while($d=mysqli_fetch_assoc($q)): ?>
<tr>
<td class="text-center"><?= $no++ ?></td>
<td><?= htmlspecialchars($d['nama']) ?></td>
<td class="text-center"><?= htmlspecialchars($d['nama_kelas']) ?></td>
<td class="text-center">
<?php if($d['dibaca_pada']): ?>
<span class="badge bg-success">Sudah Dibaca</span>
<?php else: ?>
<span class="badge bg-danger">Belum Dibaca</span>
<?php endif; ?>
</td>
<td class="text-center">
<?= $d['dibaca_pada'] ? date('d/m/Y H:i',strtotime($d['dibaca_pada'])) : '-' ?>
</td>
</tr>
<?php endwhile; ?>

</tbody>
</table>
</div>

</div>
</div>

</body>
</html>
