<?php
session_start();
require '../config/database.php';

/* ================= SECURITY ================= */
if (
    empty($_SESSION['login']) ||
    ($_SESSION['user']['role'] ?? '') !== 'tutor'
) {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= DATA TUTOR ================= */
$tutor_id = $_SESSION['user']['id'];
$nama     = $_SESSION['user']['nama'];
$foto     = $_SESSION['user']['foto'] ?? 'default.png';
$wa       = $_SESSION['user']['no_hp'] ?? '';

/* ================= FUNCTION ================= */
function countWhere($conn, $sql){
    $q = mysqli_query($conn, $sql);
    return $q ? mysqli_num_rows($q) : 0;
}

/* ================= HITUNG DATA ================= */

/* JUMLAH MATERI */
$jml_materi = countWhere($conn,"
 SELECT id FROM materi
 WHERE tutor_id = '$tutor_id'
");

/* JUMLAH KELAS YANG DIAJAR */
$jml_kelas = countWhere($conn,"
 SELECT DISTINCT j.kelas_id
 FROM jadwal j
 WHERE j.tutor_id = '$tutor_id'
");

/* JUMLAH ABSENSI SISWA */
$jml_absensi = countWhere($conn,"
 SELECT DISTINCT p.id
 FROM presensi p
 JOIN jadwal j ON j.mapel_id = p.mapel_id
 WHERE j.tutor_id = '$tutor_id'
");

/* ================= HARI INI ================= */
$mapHari = [
 'Monday'=>'Senin','Tuesday'=>'Selasa','Wednesday'=>'Rabu',
 'Thursday'=>'Kamis','Friday'=>'Jumat','Saturday'=>'Sabtu'
];
$hari_ini = $mapHari[date('l')] ?? '';

/* ================= JADWAL HARI INI ================= */
$qHariIni = mysqli_query($conn,"
 SELECT j.*, k.nama_kelas, m.nama_mapel
 FROM jadwal j
 JOIN kelas k ON k.id = j.kelas_id
 JOIN mapel m ON m.id = j.mapel_id
 WHERE j.tutor_id = '$tutor_id'
   AND j.hari = '$hari_ini'
 ORDER BY j.jam_mulai
");

$jadwalHariIni = [];
while($r = mysqli_fetch_assoc($qHariIni)){
    $jadwalHariIni[] = $r;
}

/* ================= GRAFIK ================= */
$qGrafik = mysqli_query($conn,"
 SELECT hari, COUNT(*) total
 FROM jadwal
 WHERE tutor_id = '$tutor_id'
 GROUP BY hari
");

$hariGrafik = [];
$totalGrafik = [];
while($g = mysqli_fetch_assoc($qGrafik)){
    $hariGrafik[]  = $g['hari'];
    $totalGrafik[] = $g['total'];
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Dashboard Guru</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<style>
body{background:#f4f6f9;font-size:14px}
.main-content{margin-left:260px;padding:20px;transition:.3s}
@media(max-width:991px){.main-content{margin-left:0}}

.topbar{
 display:none;
}
@media(max-width:991px){
 .topbar{
  display:flex;
  align-items:center;
  gap:10px;
  background:#0d6efd;
  color:#fff;
  padding:10px 14px;
 }
}

.card{
 border:none;
 border-radius:16px;
 animation:slideUp .4s ease;
}
@keyframes slideUp{
 from{opacity:0;transform:translateY(20px)}
 to{opacity:1;transform:translateY(0)}
}
/* ===== FOOTER MOBILE MENU ===== */
.footer-mobile{
 display:none;
}

@media(max-width:991px){
 .footer-mobile{
  display:flex;
  position:fixed;
  bottom:0;
  left:0;
  right:0;
  background:#fff;
  border-top:1px solid #ddd;
  z-index:999;
 }

 .footer-mobile a{
  flex:1;
  text-align:center;
  padding:8px 4px;
  font-size:11px;
  color:#666;
  text-decoration:none;
 }

 .footer-mobile a i{
  font-size:18px;
  display:block;
 }

 .footer-mobile a.active{
  color:#0d6efd;
  font-weight:600;
 }

 .footer-mobile a.active i{
  color:#0d6efd;
 }

 /* kasih ruang supaya konten ga ketutup footer */
 body{padding-bottom:65px}
}

</style>
</head>
<!-- FOOTER MOBILE -->
<div class="footer-mobile d-lg-none">

 <a href="profil.php" class="active">
  <i class="bi bi-person-circle"></i>
  Profil
 </a>

 <a href="absen_list_cetak.php">
  <i class="bi bi-clipboard-check"></i>
  Absen
 </a>

 <a href="materi.php">
  <i class="bi bi-journal-text"></i>
  Materi
 </a>

 <a href="elearning.php">
  <i class="bi bi-laptop"></i>
  E-Learning
 </a>

 <a href="absen_dan_jawaban.php">
  <i class="bi bi-ui-checks-grid"></i>
  Jawaban
 </a>

</div>

<body>

<!-- TOPBAR MOBILE -->
<div class="topbar d-lg-none">
<button class="btn btn-light btn-sm"
 data-bs-toggle="offcanvas"
 data-bs-target="#sidebarTutor">
 <i class="bi bi-list"></i>
</button>
<b>Dashboard Guru</b>
</div>

<?php include 'sidebar.php'; ?>

<div class="main-content">

<!-- HEADER -->
<div class="card mb-3 p-3 text-white"
 style="background:linear-gradient(135deg,#0d6efd,#0b1c2d)">
<div class="d-flex align-items-center gap-3">
<img src="../assets/img/tutor/<?= $foto ?>"
 width="60" class="rounded-circle border">
<div>
 <b><?= htmlspecialchars($nama) ?></b><br>
 <small>Tutor</small>
</div>
<span class="ms-auto badge bg-light text-dark">
 <i class="bi bi-circle-fill text-success"></i> Online
</span>
</div>
</div>

<!-- STAT -->
<div class="row g-3 mb-3">

<div class="col-6 col-md-3">
<div class="card p-3 text-center">
<i class="bi bi-journal-text fs-3 text-primary"></i>
<h5><?= $jml_materi ?></h5>
<small>Materi</small>
</div>
</div>

<div class="col-6 col-md-3">
<div class="card p-3 text-center">
<i class="bi bi-diagram-3 fs-3 text-warning"></i>
<h5><?= $jml_kelas ?></h5>
<small>Kelas</small>
</div>
</div>

<div class="col-6 col-md-3">
<div class="card p-3 text-center">
<i class="bi bi-clipboard-check fs-3 text-success"></i>
<h5><?= $jml_absensi ?></h5>
<small>Absensi</small>
</div>
</div>

</div>

<!-- JADWAL HARI INI -->
<div class="card mb-3 p-3">
<h6 class="fw-bold">
<i class="bi bi-bell"></i> Jadwal Hari Ini (<?= $hari_ini ?>)
</h6>

<?php if(empty($jadwalHariIni)){ ?>
<div class="alert alert-secondary small mb-0">
Tidak ada jadwal hari ini
</div>
<?php } else { ?>
<ul class="list-group list-group-flush">
<?php foreach($jadwalHariIni as $j){ ?>
<li class="list-group-item">
<b><?= $j['nama_mapel'] ?></b><br>
<small>
<?= $j['nama_kelas'] ?> •
<?= substr($j['jam_mulai'],0,5) ?> - <?= substr($j['jam_selesai'],0,5) ?>
</small>
</li>
<?php } ?>
</ul>
<?php } ?>
</div>

<!-- GRAFIK -->
<div class="card p-3">
<h6 class="fw-bold">
<i class="bi bi-bar-chart"></i> Grafik Jam Mengajar
</h6>
<canvas id="grafikJam" height="120"></canvas>
</div>

</div>

<!-- AUDIO -->
<audio id="notifSound">
<source src="../assets/sound/notif.mp3" type="audio/mpeg">
</audio>

<script>
new Chart(document.getElementById('grafikJam'),{
 type:'bar',
 data:{
  labels:<?= json_encode($hariGrafik) ?>,
  datasets:[{
   data:<?= json_encode($totalGrafik) ?>,
   backgroundColor:'#0d6efd'
  }]
 },
 options:{plugins:{legend:{display:false}}}
});
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
