<?php
session_start();
require '../config/database.php';

/* ================= CEK LOGIN SISWA ================= */
if (
    empty($_SESSION['login_siswa']) ||
    empty($_SESSION['siswa']['id'])
) {
    http_response_code(403);
    exit('Akses ditolak');
}

$siswa_id = (int) $_SESSION['siswa']['id'];

/* ================= VALIDASI POST ================= */
if (
    empty($_POST['mapel_id']) ||
    empty($_POST['latitude']) ||
    empty($_POST['longitude']) ||
    empty($_POST['foto'])
) {
    http_response_code(400);
    exit('Data tidak lengkap');
}

$mapel_id = (int) $_POST['mapel_id'];
$lat      = mysqli_real_escape_string($conn, $_POST['latitude']);
$lng      = mysqli_real_escape_string($conn, $_POST['longitude']);
$foto     = $_POST['foto'];

/* ================= OLAH FOTO BASE64 ================= */
$foto = str_replace('data:image/jpeg;base64,', '', $foto);
$foto = str_replace(' ', '+', $foto);
$img  = base64_decode($foto);

if (!$img) {
    http_response_code(400);
    exit('Foto tidak valid');
}

/* ================= SIMPAN FOTO ================= */
$folder = '../uploads/absen/';
if (!is_dir($folder)) {
    mkdir($folder, 0777, true);
}

$nama_file = 'absen_' . $siswa_id . '_' . time() . '.jpg';
$path = $folder . $nama_file;

file_put_contents($path, $img);

/* ================= SIMPAN KE DATABASE ================= */
$sql = "
INSERT INTO presensi (
    siswa_id,
    mapel_id,
    tanggal,
    jam,
    status,
    foto,
    latitude,
    longitude
) VALUES (
    '$siswa_id',
    '$mapel_id',
    CURDATE(),
    CURTIME(),
    'hadir',
    '$nama_file',
    '$lat',
    '$lng'
)
";

$query = mysqli_query($conn, $sql);

if (!$query) {
    http_response_code(500);
    exit('Gagal simpan presensi');
}

/* ================= REDIRECT ================= */
header("Location: dashboard.php?absen=ok");
exit;
