<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Login Siswa PKBM</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">

<style>
body{
  background:linear-gradient(135deg,#0b1c2d,#1e3c72);
}

.card-login{
  width:100%;
  max-width:360px;
  border-radius:18px;
}

.logo{
  width:90px;
  height:auto;
  margin-bottom:10px;
}

.form-control{
  border-radius:10px;
}

.btn{
  border-radius:12px;
}

button:hover{
  opacity:.95;
}

@media(max-width:576px){
  .logo{width:70px;}
}
</style>
</head>

<body class="d-flex justify-content-center align-items-center vh-100">

<div class="card card-login shadow">
  <div class="card-body p-4">

    <!-- LOGO -->
    <div class="text-center mb-2">
      <img src="../assets/img/logo.jpg" class="logo" alt="Logo PKBM">
    </div>

    <h4 class="text-center fw-bold mb-1">LOGIN SISWA</h4>
    <p class="text-center text-muted mb-4">PKBM TARUNA QURANI</p>

    <!-- ERROR -->
    <?php if(isset($_GET['error'])): ?>
      <div class="alert alert-danger py-2 small text-center">
        <?= htmlspecialchars($_GET['error']) ?>
      </div>
    <?php endif; ?>

    <form action="login_siswa_proses.php" method="POST">

      <div class="mb-3">
        <label class="form-label small fw-semibold">Username</label>
        <input type="text" name="username" class="form-control"
               placeholder="Masukkan username" required>
      </div>

      <div class="mb-3">
        <label class="form-label small fw-semibold">Password</label>
        <input type="password" name="password" class="form-control"
               placeholder="Tanggal lahir (ddmmyyyy)" required>
      </div>

      <button class="btn btn-primary w-100 mb-2">
        <i class="bi bi-box-arrow-in-right"></i> Login
      </button>

      <a href="/sydra_academy/" class="btn btn-secondary w-100">
        Batal
      </a>

    </form>

    <hr>

    <div class="text-center small text-muted">
      Default password: <b>Tanggal Lahir (ddmmyyyy)</b>
    </div>

  </div>
</div>

</body>
</html>
