<?php
session_start();
require "../config/database.php";

/* ================== PROTEKSI ================== */
if (empty($_SESSION['login']) || $_SESSION['user']['role'] != 'admin') {
    exit("Akses ditolak");
}

/* ================== FILTER ================== */
$guru   = $_GET['guru'] ?? '';
$bulan  = $_GET['bulan'] ?? '';
$minggu = $_GET['minggu'] ?? '';

$where = [];

/* filter guru */
if ($guru != '') {
    $guru = mysqli_real_escape_string($conn,$guru);
    $where[] = "u.id='$guru'";
}

/* filter bulan (YYYY-MM) */
if ($bulan != '') {
    $where[] = "DATE_FORMAT(p.tanggal,'%Y-%m')='$bulan'";
}

/* filter minggu (YYYY-WW) */
if ($minggu != '') {
    $where[] = "YEARWEEK(p.tanggal,1) = YEARWEEK('$minggu',1)";
}

$whereSql = count($where) ? 'WHERE '.implode(' AND ',$where) : '';

/* ================== DATA PRESENSI ================== */
$data = mysqli_query($conn,"
    SELECT
        p.tanggal,
        p.waktu AS jam_masuk,
        p.waktu_pulang AS jam_pulang,
        p.status,
        u.nama AS nama_guru
    FROM presensi_guru p
    JOIN users u ON p.tutor_id=u.id
    $whereSql
    ORDER BY u.nama,p.tanggal
");

/* ================== REKAP HADIR ================== */
$rekap_hadir = mysqli_fetch_assoc(mysqli_query($conn,"
    SELECT
        SUM(p.status='Hadir') AS hadir
    FROM presensi_guru p
    JOIN users u ON p.tutor_id=u.id
    $whereSql
"));

/* ================== REKAP IZIN CUTI (APPROVED) ================== */
$whereIzin = [];

if ($guru!='') {
    $whereIzin[] = "tutor_id='$guru'";
}

if ($bulan!='') {
    $whereIzin[] = "DATE_FORMAT(tanggal_mulai,'%Y-%m')='$bulan'";
}

if ($minggu!='') {
    $whereIzin[] = "YEARWEEK(tanggal_mulai,1)=YEARWEEK('$minggu',1)";
}

$whereIzinSql = count($whereIzin)
    ? 'AND '.implode(' AND ',$whereIzin)
    : '';

$rekap_izin = mysqli_fetch_assoc(mysqli_query($conn,"
    SELECT
        SUM(jenis='izin')  AS izin,
        SUM(jenis='cuti')  AS cuti,
        SUM(jenis='sakit') AS sakit
    FROM izin_cuti
    WHERE status_approval='approved'
    $whereIzinSql
"));
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Cetak Presensi Guru</title>
<style>
body{font-family:Arial;font-size:12px}
table{border-collapse:collapse;width:100%}
th,td{border:1px solid #000;padding:6px}
th{background:#eee;text-align:center}
.text-center{text-align:center}
h3{text-align:center;margin-bottom:15px}
.rekap-table{
    width:260px;
    float:right;
    margin-top:10px;
}

</style>
</head>

<body onload="window.print()">

<h3>
PRESENSI GURU<br>
PKBM TARUNA QURANI
</h3>

<table>
<tr>
    <th>No</th>
    <th>Nama Guru</th>
    <th>Tanggal</th>
    <th>Jam Masuk</th>
    <th>Jam Pulang</th>
    <th>Status</th>
</tr>

<?php $no=1; while($r=mysqli_fetch_assoc($data)): ?>
<tr>
    <td class="text-center"><?= $no++ ?></td>
    <td><?= htmlspecialchars($r['nama_guru']) ?></td>
    <td class="text-center"><?= date('d-m-Y',strtotime($r['tanggal'])) ?></td>
    <td class="text-center"><?= $r['jam_masuk'] ?: '-' ?></td>
    <td class="text-center"><?= $r['jam_pulang'] ?: '-' ?></td>
    <td class="text-center"><?= strtoupper($r['status']) ?></td>
</tr>
<?php endwhile; ?>
</table>

<br>

<!-- ================== REKAP ================== -->
<table class="rekap-table">

<tr>
    <th colspan="2">REKAP PRESENSI</th>
</tr>
<tr>
    <td>Hadir</td>
    <td class="text-center"><b><?= $rekap_hadir['hadir'] ?? 0 ?></b></td>
</tr>
<tr>
    <td>Izin</td>
    <td class="text-center"><b><?= $rekap_izin['izin'] ?? 0 ?></b></td>
</tr>
<tr>
    <td>Sakit</td>
    <td class="text-center"><b><?= $rekap_izin['sakit'] ?? 0 ?></b></td>
</tr>
<tr>
    <td>Cuti</td>
    <td class="text-center"><b><?= $rekap_izin['cuti'] ?? 0 ?></b></td>
</tr>
</table>

<br><br><br>

<table width="100%" style="border:none">
<tr>
<td width="65%" style="border:none"></td>
<td style="border:none;text-align:center">
<?= date('d-m-Y') ?><br>
Admin<br><br><br>
<b><?= $_SESSION['user']['nama'] ?></b>
</td>
</tr>
</table>

</body>
</html>
