<?php
session_start();
require '../config/database.php';

/* ================= PROTEKSI ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    exit('Akses ditolak');
}

/* ================= FILTER ================= */
$q      = $_GET['q'] ?? '';
$guru   = $_GET['guru'] ?? '';
$mode   = $_GET['mode'] ?? '';
$bulan  = $_GET['bulan'] ?? date('Y-m');
$minggu = $_GET['minggu'] ?? date('Y-m-d');

/* ================= FILTER PRESENSI ================= */
$whereArr = [];

if ($q != '') {
    $qSafe = mysqli_real_escape_string($conn, $q);
    $whereArr[] = "(u.nama LIKE '%$qSafe%' OR p.status LIKE '%$qSafe%')";
}

if ($guru != '') {
    $whereArr[] = "p.tutor_id='".intval($guru)."'";
}

if ($mode == 'bulan') {
    $whereArr[] = "DATE_FORMAT(p.tanggal,'%Y-%m')='$bulan'";
}

if ($mode == 'minggu') {
    $whereArr[] = "YEARWEEK(p.tanggal,1)=YEARWEEK('$minggu',1)";
}

$whereSql = $whereArr ? 'WHERE '.implode(' AND ', $whereArr) : '';

/* ================= DATA PRESENSI ================= */
$data = mysqli_query($conn,"
    SELECT 
        u.nama AS nama_guru,
        p.tanggal,
        p.waktu AS jam_masuk,
        p.waktu_pulang AS jam_pulang,
        p.status
    FROM presensi_guru p
    JOIN users u ON p.tutor_id = u.id
    $whereSql
    ORDER BY p.tanggal DESC
");

/* ================= HADIR ================= */
$whereHadir = $whereArr
    ? $whereSql." AND p.status='Hadir'"
    : "WHERE p.status='Hadir'";

$qHadir = mysqli_fetch_assoc(mysqli_query($conn,"
    SELECT COUNT(*) AS hadir
    FROM presensi_guru p
    $whereHadir
"));

/* ================= FILTER IZIN / CUTI ================= */
$whereIzinArr = ["status_approval='approved'"]; // FIX PENTING

if ($guru != '') {
    $whereIzinArr[] = "tutor_id='".intval($guru)."'";
}

if ($mode == 'bulan') {
    $whereIzinArr[] = "
        tanggal_mulai <= LAST_DAY('$bulan-01')
        AND tanggal_selesai >= '$bulan-01'
    ";
}

if ($mode == 'minggu') {
    $whereIzinArr[] = "
        tanggal_mulai <= DATE_ADD('$minggu', INTERVAL 6 DAY)
        AND tanggal_selesai >= '$minggu'
    ";
}

$whereIzinSql = 'WHERE '.implode(' AND ', $whereIzinArr);


/* ================= IZIN / CUTI ================= */
$qIzin = mysqli_fetch_assoc(mysqli_query($conn,"
    SELECT
        SUM(CASE WHEN jenis='sakit' THEN DATEDIFF(tanggal_selesai, tanggal_mulai) + 1 ELSE 0 END) AS sakit,
        SUM(CASE WHEN jenis='izin'  THEN DATEDIFF(tanggal_selesai, tanggal_mulai) + 1 ELSE 0 END) AS izin,
        SUM(CASE WHEN jenis='cuti'  THEN DATEDIFF(tanggal_selesai, tanggal_mulai) + 1 ELSE 0 END) AS cuti,
        SUM(CASE WHEN jenis='dinas' THEN DATEDIFF(tanggal_selesai, tanggal_mulai) + 1 ELSE 0 END) AS dinas
    FROM izin_cuti
    $whereIzinSql
"));

/* ================= REKAP FINAL ================= */
$rekap = [
    'hadir' => ($qHadir['hadir'] ?? 0) + ($qIzin['dinas'] ?? 0),
    'sakit' => $qIzin['sakit'] ?? 0,
    'izin'  => $qIzin['izin'] ?? 0,
    'cuti'  => $qIzin['cuti'] ?? 0
];
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Presensi Guru</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<style>
/* ================= GLOBAL ================= */
html, body {
    height: 100%;
    overflow-x: hidden;   /* HILANGKAN SCROLL SAMPING */
}

body {
    background: #f4f6f9;
}

/* ================= MAIN CONTENT ================= */
.main-content {
    margin-left: 260px;
    padding: 16px;
    min-height: 100vh;
}

/* MOBILE */
@media (max-width: 768px) {
    .main-content {
        margin-left: 0;
        padding: 12px;
    }
}

/* ================= REKAP ================= */
.rekap-card {
    text-align: center;
    padding: 12px;
    min-height: 80px;
    border-radius: 10px;
}

.rekap-title {
    font-size: 12px;
    font-weight: 500;
}

.rekap-value {
    font-size: 22px;
    font-weight: 700;
}

/* MOBILE REKAP */
@media (max-width: 576px) {
    .rekap-value {
        font-size: 18px;
    }
}

/* ================= FILTER ================= */
form.row.g-2 {
    background: #fff;
    padding: 12px;
    border-radius: 10px;
    box-shadow: 0 2px 6px rgba(0,0,0,.05);
}

/* ================= TABLE ================= */
.table-responsive {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
}

table {
    white-space: nowrap;
}

/* ================= FOOTER FIX ================= */
footer {
    margin-top: 20px;
}

</style>

</head>

<body class="bg-light">
<?php include __DIR__.'/partials/sidebar.php'; ?>

<div class="main-content">

    <div class="d-flex align-items-center gap-2 mb-3">
        <button class="btn btn-outline-primary d-md-none"
                data-bs-toggle="offcanvas"
                data-bs-target="#sidebarAdmin">
            <i class="bi bi-list"></i>
        </button>
        <h5 class="mb-0 d-flex align-items-center gap-2">
            <i class="bi bi-clipboard-check"></i> Presensi Guru
        </h5>
    </div>

<!-- REKAP -->
<div class="row g-2 mb-3">
    <div class="col-6 col-md-3"><div class="card text-bg-success rekap-card"><div class="rekap-title">Hadir</div><div class="rekap-value"><?= $rekap['hadir'] ?></div></div></div>
    <div class="col-6 col-md-3"><div class="card text-bg-info rekap-card"><div class="rekap-title">Sakit</div><div class="rekap-value"><?= $rekap['sakit'] ?></div></div></div>
    <div class="col-6 col-md-3"><div class="card text-bg-warning rekap-card"><div class="rekap-title">Izin</div><div class="rekap-value"><?= $rekap['izin'] ?></div></div></div>
    <div class="col-6 col-md-3"><div class="card text-bg-danger rekap-card"><div class="rekap-title">Cuti</div><div class="rekap-value"><?= $rekap['cuti'] ?></div></div></div>
</div>

<!-- FILTER -->
<form class="row g-2 mb-3">
    <div class="col-md-3">
        <select name="guru" class="form-select">
            <option value="">Semua Guru</option>
            <?php
            $g = mysqli_query($conn,"SELECT id,nama FROM users WHERE role='tutor'");
            while($gr=mysqli_fetch_assoc($g)):
            ?>
            <option value="<?= $gr['id'] ?>" <?= $guru==$gr['id']?'selected':'' ?>>
                <?= $gr['nama'] ?>
            </option>
            <?php endwhile ?>
        </select>
    </div>
    <div class="col-md-2">
        <select name="mode" class="form-select">
            <option value="">Semua</option>
            <option value="minggu" <?= $mode=='minggu'?'selected':'' ?>>Per Minggu</option>
            <option value="bulan" <?= $mode=='bulan'?'selected':'' ?>>Per Bulan</option>
        </select>
    </div>
    <div class="col-md-2"><input type="month" name="bulan" value="<?= $bulan ?>" class="form-control"></div>
    <div class="col-md-2"><input type="date" name="minggu" value="<?= $minggu ?>" class="form-control"></div>
    <div class="col-md-3"><button class="btn btn-primary w-100"><i class="bi bi-filter"></i> Terapkan</button></div>
    <a href="presensi_guru_cetak.php?<?= http_build_query($_GET) ?>"
   target="_blank"
   class="btn btn-danger btn-sm">
   <i class="bi bi-printer"></i> Cetak
</a>

</form>

<!-- TABEL -->
<div class="card">
<div class="card-body table-responsive">
<table class="table table-bordered table-striped align-middle">
<thead class="table-light">
<tr>
    <th>No</th>
    <th>Nama Guru</th>
    <th>Tanggal</th>
    <th>Jam Masuk</th>
    <th>Jam Pulang</th>
    <th>Status</th>
</tr>
</thead>
<tbody>
<?php $no=1; while($r=mysqli_fetch_assoc($data)): ?>
<tr>
    <td><?= $no++ ?></td>
    <td><?= $r['nama_guru'] ?></td>
    <td><?= date('d-m-Y',strtotime($r['tanggal'])) ?></td>
    <td><?= $r['jam_masuk'] ?: '-' ?></td>
    <td><?= $r['jam_pulang'] ?: '-' ?></td>
    <?php
$badge = match ($r['status']) {
    'Hadir' => 'success',
    'Sakit' => 'info',
    'Izin'  => 'warning',
    'Cuti'  => 'danger',
    default => 'secondary'
};
?>
<td>
    <span class="badge bg-<?= $badge ?>">
        <?= $r['status'] ?>
    </span>
</td>

</tr>
<?php endwhile ?>
</tbody>
</table>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
