<?php
session_start();
require '../config/database.php';

/* DEBUG (boleh dimatikan jika sudah fix) */
error_reporting(E_ALL);
ini_set('display_errors', 1);

/* ================= PROTEKSI ================= */
if (empty($_SESSION['login']) || ($_SESSION['user']['role'] ?? '') !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= HELPER ================= */
function formatKelasPaket($kelas, $paket) {
    if (!$kelas) return '-';
    return $paket ? "$kelas-$paket" : $kelas;
}

function badgeStatus($status) {
    $status = strtolower($status ?? '');
    return match($status) {
        'hadir' => '<span class="badge bg-success">Hadir</span>',
        'izin'  => '<span class="badge bg-warning text-dark">Izin</span>',
        'alfa'  => '<span class="badge bg-danger">Alfa</span>',
        default => '<span class="badge bg-secondary">'.htmlspecialchars($status).'</span>',
    };
}

/* ================= FILTER ================= */
$kelas_id = $_GET['kelas_id'] ?? '';
$mapel_id = $_GET['mapel_id'] ?? '';
$tutor_id = $_GET['tutor_id'] ?? '';

$where = "WHERE 1=1";
if ($kelas_id !== '') $where .= " AND k.id='".mysqli_real_escape_string($conn,$kelas_id)."'";
if ($mapel_id !== '') $where .= " AND mp.id='".mysqli_real_escape_string($conn,$mapel_id)."'";
if ($tutor_id !== '') $where .= " AND km.tutor_id='".mysqli_real_escape_string($conn,$tutor_id)."'";

/* ================= FILTER TANGGAL ================= */
$mode = $_GET['mode'] ?? 'harian';
$tgl1 = $_GET['tgl1'] ?? date('Y-m-d');
$tgl2 = $_GET['tgl2'] ?? date('Y-m-d');

switch ($mode) {
    case 'harian':
        $awal = $akhir = $tgl1;
        break;
    case 'mingguan':
        $awal  = date('Y-m-d', strtotime('monday this week', strtotime($tgl1)));
        $akhir = date('Y-m-d', strtotime('sunday this week', strtotime($tgl1)));
        break;
    case 'bulanan':
        $awal  = date('Y-m-01', strtotime($tgl1));
        $akhir = date('Y-m-t', strtotime($tgl1));
        break;
    default:
        $awal  = $tgl1;
        $akhir = $tgl2;
        break;
}

/* ================= DATA DROPDOWN ================= */
/* Kelas & Paket */
$qKelas = mysqli_query($conn,"
    SELECT k.id, CONCAT(k.nama_kelas, IFNULL(CONCAT('-', p.nama), '')) AS label
    FROM kelas k
    LEFT JOIN paket p ON p.id = k.paket_id
    ORDER BY k.nama_kelas, p.nama
");

/* Mapel */
$qMapel = mysqli_query($conn,"SELECT id, nama_mapel FROM mapel ORDER BY nama_mapel");

/* Tutor (diambil dari users dengan role=tutor) */
$qTutor = mysqli_query($conn,"
    SELECT id, nama
    FROM users
    WHERE role='tutor'
    ORDER BY nama
");

/* ================= DATA ABSEN ================= */
$sqlPresensi = "
SELECT
    s.nama AS nama_siswa,
    k.nama_kelas,
    p.nama AS nama_paket,
    mp.nama_mapel,
    u.nama AS nama_tutor,   -- ambil dari users
    pr.tanggal,
    pr.jam,
    pr.status
FROM presensi pr
JOIN siswa s ON s.id = pr.siswa_id
JOIN kelas k ON k.id = s.kelas_id
LEFT JOIN paket p ON p.id = k.paket_id
JOIN mapel mp ON mp.id = pr.mapel_id
JOIN kelas_mengajar km 
    ON km.kelas_id = k.id AND km.mapel_id = mp.id
JOIN users u ON u.id = km.tutor_id AND u.role='tutor'
$where
AND pr.tanggal BETWEEN '$awal' AND '$akhir'
ORDER BY pr.tanggal DESC, pr.jam DESC
";

$q = mysqli_query($conn, $sqlPresensi);
if (!$q) die("Query presensi error: " . mysqli_error($conn));
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Presensi Siswa (Admin)</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{background:#f4f6f9;font-size:14px;margin:0;font-family:'Segoe UI',sans-serif;}
.main-content{margin-left:260px;padding:20px;}
@media(max-width:991px){.main-content{margin-left:0;}}
.card{border-radius:16px;}
.table img{width:40px;height:40px;object-fit:cover;border-radius:50%;}
/* ===== TOPBAR ===== */
.topbar{
    position: fixed;
    top: 0;
    left: 260px;      /* sesuaikan dengan lebar sidebar */
    right: 0;
    height: 56px;
    background: #fff;
    border-bottom: 1px solid #ddd;
    z-index: 1020;
    display: flex;
    align-items: center;
    padding: 0 16px;
}

/* ===== MAIN CONTENT ===== */
.main-content{
    margin-left: 260px;      /* ruang untuk sidebar */
    padding: 90px 20px 60px; /* atas: 90px supaya ada jarak dari topbar */
}

/* ===== RESPONSIVE ===== */
@media(max-width:991px){
    .topbar{left:0}
    .main-content{margin-left:0; padding-top: 90px} /* tetap beri jarak atas */
}

@media(max-width:991px){.topbar{left:0;}}
</style>
</head>
<body>

<?php include __DIR__ . '/partials/sidebar.php'; ?>

<!-- TOPBAR -->
<div class="topbar">
    <button class="btn btn-outline-primary d-lg-none me-2" data-bs-toggle="offcanvas" data-bs-target="#sidebarAdmin">
        <i class="bi bi-list"></i>
    </button>
    <span class="fw-semibold ms-2">Presensi Siswa</span>
    <span class="ms-auto small"><?= htmlspecialchars($_SESSION['user']['nama'] ?? '') ?></span>
</div>

<!-- MAIN CONTENT -->
<div class="main-content container-fluid mt-4">

<!-- FILTER CARD -->
<div class="card mb-3">
    <div class="card-body">
        <form class="row g-2" method="get">

            <div class="col-md-3">
                <label class="small">Kelas</label>
                <select name="kelas_id" class="form-select form-select-sm">
                    <option value="">Semua Kelas</option>
                    <?php while($k=mysqli_fetch_assoc($qKelas)): ?>
                        <option value="<?= $k['id'] ?>" <?= $kelas_id==$k['id']?'selected':'' ?>><?= htmlspecialchars($k['label']) ?></option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="col-md-3">
                <label class="small">Mapel</label>
                <select name="mapel_id" class="form-select form-select-sm">
                    <option value="">Semua Mapel</option>
                    <?php while($m=mysqli_fetch_assoc($qMapel)): ?>
                        <option value="<?= $m['id'] ?>" <?= $mapel_id==$m['id']?'selected':'' ?>><?= htmlspecialchars($m['nama_mapel']) ?></option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="col-md-3">
                <label class="small">Tutor/Guru</label>
                <select name="tutor_id" class="form-select form-select-sm">
                    <option value="">Semua Tutor/Guru</option>
                    <?php while($t=mysqli_fetch_assoc($qTutor)): ?>
                        <option value="<?= $t['id'] ?>" <?= $tutor_id==$t['id']?'selected':'' ?>><?= htmlspecialchars($t['nama']) ?></option>
                    <?php endwhile; ?>
                </select>
            </div>

            <div class="col-md-2">
                <label class="small">Mode</label>
                <select name="mode" class="form-select form-select-sm">
                    <option value="harian" <?= $mode=='harian'?'selected':'' ?>>Harian</option>
                    <option value="mingguan" <?= $mode=='mingguan'?'selected':'' ?>>Mingguan</option>
                    <option value="bulanan" <?= $mode=='bulanan'?'selected':'' ?>>Bulanan</option>
                    <option value="range" <?= $mode=='range'?'selected':'' ?>>Rentang</option>
                </select>
            </div>

            <div class="col-md-2">
                <label class="small">Tanggal</label>
                <input type="date" name="tgl1" value="<?= htmlspecialchars($tgl1) ?>" class="form-control form-control-sm">
            </div>

            <?php if($mode=='range'): ?>
                <div class="col-md-2">
                    <label class="small">Sampai</label>
                    <input type="date" name="tgl2" value="<?= htmlspecialchars($tgl2) ?>" class="form-control form-control-sm">
                </div>
            <?php endif; ?>

            <div class="col-md-2 d-flex align-items-end">
                <button class="btn btn-primary btn-sm w-100"><i class="bi bi-funnel"></i> Filter</button>
            </div>

            <div class="col-md-2 d-flex align-items-end">
                <a href="presensi_admin_cetak.php?<?= http_build_query($_GET) ?>" target="_blank" class="btn btn-success btn-sm w-100">
                    <i class="bi bi-printer"></i> Cetak PDF
                </a>
            </div>

        </form>
    </div>
</div>

<!-- TABEL PRESENSI -->
<div class="card">
    <div class="card-header bg-primary text-white"><i class="bi bi-clipboard-check"></i> Daftar Presensi Siswa</div>
    <div class="card-body table-responsive">
        <table class="table table-bordered table-striped table-hover align-middle text-center">
            <thead class="table-light">
                <tr>
                    <th>No</th>
                    <th>Nama</th>
                    <th>Kelas</th>
                    <th>Mapel</th>
                    <th>Tutor</th>
                    <th>Tanggal</th>
                    <th>Jam</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php if(mysqli_num_rows($q)==0): ?>
                    <tr><td colspan="8" class="text-center text-muted">Tidak ada data</td></tr>
                <?php else: $no=1; while($r=mysqli_fetch_assoc($q)): ?>
                    <tr>
                        <td><?= $no++ ?></td>
                        <td><?= htmlspecialchars($r['nama_siswa']) ?></td>
                        <td><?= htmlspecialchars(formatKelasPaket($r['nama_kelas'],$r['nama_paket'])) ?></td>
                        <td><?= htmlspecialchars($r['nama_mapel']) ?></td>
                        <td><?= htmlspecialchars($r['nama_tutor']) ?></td>
                        <td><?= date('d-m-Y', strtotime($r['tanggal'])) ?></td>
                        <td><?= htmlspecialchars(substr($r['jam'],0,5)) ?></td>
                        <td><?= badgeStatus($r['status']) ?></td>
                    </tr>
                <?php endwhile; endif; ?>
            </tbody>
        </table>
    </div>
</div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
