<?php
session_start();
require '../config/database.php';

/* ================= SECURITY ================= */
if (
    empty($_SESSION['login']) ||
    empty($_SESSION['user']) ||
    ($_SESSION['user']['role'] ?? '') !== 'admin'
) {
    header("Location: ../auth/login.php");
    exit;
}

/* ================= INPUT ================= */
$id = 1;
$nama_sekolah   = mysqli_real_escape_string($conn, $_POST['nama_sekolah']);
$npsn           = mysqli_real_escape_string($conn, $_POST['npsn']);
$alamat         = mysqli_real_escape_string($conn, $_POST['alamat']);
$kepsek         = mysqli_real_escape_string($conn, $_POST['kepala_sekolah']);

/* ================= DATA LAMA ================= */
$data = mysqli_fetch_assoc(
    mysqli_query($conn, "SELECT logo FROM pkbm WHERE id=1")
);
$logo_lama = $data['logo'] ?? 'logo.jpg';

/* ================= UPLOAD LOGO ================= */
$logo_baru = $logo_lama;

if (!empty($_FILES['logo']['name'])) {

    $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
    $allowed = ['jpg','jpeg','png','webp'];

    if (!in_array($ext, $allowed)) {
        die('Format logo tidak diizinkan');
    }

    if ($_FILES['logo']['size'] > 2 * 1024 * 1024) {
        die('Ukuran logo maksimal 2MB');
    }

    $logo_baru = 'logo_' . time() . '.' . $ext;
    move_uploaded_file(
        $_FILES['logo']['tmp_name'],
        '../assets/img/' . $logo_baru
    );

    if ($logo_lama && $logo_lama != 'logo.jpg' && file_exists('../assets/img/'.$logo_lama)) {
        unlink('../assets/img/'.$logo_lama);
    }
}

/* ================= UPDATE ================= */
mysqli_query($conn, "
    UPDATE pkbm SET
        nama_sekolah='$nama_sekolah',
        npsn='$npsn',
        alamat='$alamat',
        kepala_sekolah='$kepsek',
        logo='$logo_baru'
    WHERE id=1
");

/* ================= REDIRECT ================= */
header("Location: dashboard.php?update=success");
exit;
