<?php
session_start();
require '../config/database.php';

if (!isset($_SESSION['login']) || $_SESSION['user']['role'] != 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

$page_title = 'Mata Pelajaran';
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= $page_title ?></title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{background:#f4f6f9;margin:0; font-family:'Segoe UI', sans-serif}

/* ===== TOPBAR ===== */
.topbar{
 position:fixed;top:0;left:260px;right:0;height:56px;
 background:#fff;border-bottom:1px solid #ddd;
 z-index:1020;display:flex;align-items:center;padding:0 16px;font-weight:500;
}

/* ===== MAIN CONTENT ===== */
.main-content{
 margin-left:260px;
 padding-top:70px;
 padding-bottom:60px;
 max-width: 1100px; /* pas di laptop */
}

/* ===== CARD ===== */
.content-card{
 background:#fff;
 border-radius:18px;
 box-shadow:0 6px 18px rgba(0,0,0,.08);
 padding:20px;
 margin-bottom:20px;
}

/* ===== TABLE ===== */
.table-hover tbody tr:hover{background:rgba(0,123,255,0.05)}
.table th, .table td{text-align:center; vertical-align:middle;}

/* ===== BUTTON ===== */
.btn-primary, .btn-warning, .btn-danger{
 border-radius:8px;
 transition:.2s;
}
.btn-primary:hover{background:#0d6efd; transform:translateY(-2px);}
.btn-warning:hover{background:#ffc107; transform:translateY(-2px);}
.btn-danger:hover{background:#dc3545; transform:translateY(-2px);}

/* ===== FOOTER ===== */
footer{
 position:fixed;bottom:0;left:260px;right:0;
 background:#fff;border-top:1px solid #ddd;
 text-align:center;font-size:14px;padding:8px;
}

/* ===== MOBILE ===== */
@media(max-width:991px){
 .topbar{left:0}
 .main-content{margin-left:0;padding-top:90px}
 footer{left:0}
}
</style>
</head>
<body>

<!-- ===== SIDEBAR INCLUDE ===== -->
<?php include __DIR__ . '/partials/sidebar.php'; ?>

<!-- ===== TOPBAR ===== -->
<div class="topbar">
 <button class="btn btn-outline-primary d-lg-none" data-bs-toggle="offcanvas" data-bs-target="#sidebarAdmin">
  <i class="bi bi-list"></i>
 </button>
 <span class="fw-semibold ms-2">
 <?= $page_title ?> <small class="text-muted">(<?= htmlspecialchars($tahun_nama ?? '') ?>)</small>
 </span>
 <span class="ms-auto small"><?= htmlspecialchars($_SESSION['user']['nama'] ?? '') ?></span>
</div>

<!-- ===== MAIN CONTENT ===== -->
<div class="main-content container-fluid">
 <div class="content-card">
     <div class="d-flex justify-content-between align-items-center mb-3">
         <h5><i class="bi bi-book"></i> Daftar Mapel</h5>
         <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalTambah">
             <i class="bi bi-plus-circle"></i> Tambah Mapel
         </button>
     </div>

     <div class="table-responsive">
     <table class="table table-bordered table-hover align-middle">
     <thead class="table-dark text-center">
     <tr>
         <th>Nama Mapel</th>
         <th>Maks Materi</th>
         <th>Aksi</th>
     </tr>
     </thead>
     <tbody>
     <?php
     $q=mysqli_query($conn,"SELECT * FROM mapel ORDER BY nama_mapel");
     if(mysqli_num_rows($q)==0){
         echo '<tr><td colspan="3" class="text-center text-muted">Belum ada mapel</td></tr>';
     }
     while($d=mysqli_fetch_assoc($q)){
     ?>
     <tr>
         <td><?= htmlspecialchars($d['nama_mapel']) ?></td>
         <td><?= $d['max_materi'] ?: '<span class="text-muted">∞</span>' ?></td>
         <td>
             <button class="btn btn-warning btn-sm btn-edit"
              data-id="<?= $d['id'] ?>"
              data-nama="<?= htmlspecialchars($d['nama_mapel']) ?>"
              data-max="<?= $d['max_materi'] ?>">
              <i class="bi bi-pencil"></i>
             </button>
             <button class="btn btn-danger btn-sm btn-hapus" data-id="<?= $d['id'] ?>">
              <i class="bi bi-trash"></i>
             </button>
         </td>
     </tr>
     <?php } ?>
     </tbody>
     </table>
     </div>
 </div>
</div>

<footer>
 © <?= date('Y') ?> PKBM Taruna Qurani — Developed by <b>Bang Zae</b>
</footer>

<!-- ===== MODAL TAMBAH ===== -->
<div class="modal fade" id="modalTambah">
 <div class="modal-dialog modal-dialog-centered">
  <form method="post" action="mapel_proses.php" class="modal-content">
   <input type="hidden" name="aksi" value="tambah">
   <div class="modal-header">
    <h5>Tambah Mapel</h5>
    <button class="btn-close" data-bs-dismiss="modal"></button>
   </div>
   <div class="modal-body">
    <label>Nama Mapel</label>
    <input type="text" name="nama_mapel" class="form-control mb-2" required>
    <label>Maks Materi (0 = tak terbatas)</label>
    <input type="number" name="max_materi" class="form-control" value="0">
   </div>
   <div class="modal-footer">
    <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
    <button class="btn btn-primary">Simpan</button>
   </div>
  </form>
 </div>
</div>

<!-- ===== MODAL EDIT ===== -->
<div class="modal fade" id="modalEdit">
 <div class="modal-dialog modal-dialog-centered">
  <form method="post" action="mapel_proses.php" class="modal-content">
   <input type="hidden" name="aksi" value="edit">
   <input type="hidden" name="id" id="edit_id">
   <div class="modal-header">
    <h5>Edit Mapel</h5>
    <button class="btn-close" data-bs-dismiss="modal"></button>
   </div>
   <div class="modal-body">
    <label>Nama Mapel</label>
    <input type="text" name="nama_mapel" id="edit_nama" class="form-control mb-2">
    <label>Maks Materi</label>
    <input type="number" name="max_materi" id="edit_max" class="form-control">
   </div>
   <div class="modal-footer">
    <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
    <button class="btn btn-warning">Update</button>
   </div>
  </form>
 </div>
</div>

<!-- ===== MODAL HAPUS ===== -->
<div class="modal fade" id="modalHapus">
 <div class="modal-dialog modal-dialog-centered">
  <form method="post" action="mapel_proses.php" class="modal-content">
   <input type="hidden" name="aksi" value="hapus">
   <input type="hidden" name="id" id="hapus_id">
   <div class="modal-header bg-danger text-white">
    <h5>Hapus Mapel</h5>
   </div>
   <div class="modal-body text-center">
    Yakin ingin menghapus mapel ini?
   </div>
   <div class="modal-footer">
    <button class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
    <button class="btn btn-danger">Hapus</button>
   </div>
  </form>
 </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.querySelectorAll('.btn-edit').forEach(b=>{
 b.onclick=()=>{
  edit_id.value=b.dataset.id
  edit_nama.value=b.dataset.nama
  edit_max.value=b.dataset.max
  new bootstrap.Modal(modalEdit).show()
 }
})
document.querySelectorAll('.btn-hapus').forEach(b=>{
 b.onclick=()=>{
  hapus_id.value=b.dataset.id
  new bootstrap.Modal(modalHapus).show()
 }
})
</script>

</body>
</html>
