<?php
session_start();
require "../config/database.php";

if (empty($_SESSION['login']) || $_SESSION['user']['role'] != 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

$q = mysqli_query($conn, "
  SELECT i.*, t.nama, t.no_hp
  FROM izin_cuti i
  JOIN tutor t ON i.tutor_id=t.id
  ORDER BY i.created_at DESC
");
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Approval Izin/Cuti</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<style>
body{background:#f5f7fa;font-family:Segoe UI}
.table-sm td,.table-sm th{padding:6px!important}
.badge{font-size:12px;padding:5px 8px}
.pending{background:#ffc10720;color:#b88600;border:1px solid #ffc107}
.approved{background:#28a74520;color:#1e7e34;border:1px solid #28a745}
.rejected{background:#dc354520;color:#a71d2a;border:1px solid #dc3545}

.menu-active{background:rgba(255,255,255,.15)!important}
/* ===== KONTEN ===== */
.main-content{
  margin-left:260px;
  transition:.3s;
}

body.sidebar-collapsed .main-content{
  margin-left:80px;
}

/* ===== CARD ===== */
.card{
  border-radius:14px;
  border:none;
}

/* ===== TABLE ===== */
.table{
  white-space:nowrap;
  font-size:14px;
}

.table thead th{
  background:#212529;
  color:#fff;
  vertical-align:middle;
}

.table tbody td{
  vertical-align:middle;
}

/* ===== BADGE STATUS ===== */
.badge.pending{
  background:#fff3cd;
  color:#856404;
  border:1px solid #ffeeba;
}
.badge.approved{
  background:#d4edda;
  color:#155724;
  border:1px solid #c3e6cb;
}
.badge.rejected{
  background:#f8d7da;
  color:#721c24;
  border:1px solid #f5c6cb;
}

/* ===== MOBILE ===== */
@media(max-width:768px){
  .main-content{
    margin-left:0;
  }
  .table-responsive{
    border-radius:12px;
    overflow:auto;
  }
}

@media(max-width:767px){
  .container-fluid{
    margin-left:0 !important;
  }
}
.topbar{
  background:#fff;
  padding:14px 18px;
  border-radius:14px;
  box-shadow:0 2px 10px rgba(0,0,0,.05);
  display:flex;
  justify-content:space-between;
  align-items:center;
}

.topbar .btn{
  border-radius:10px;
}

</style>
</head>
<body>

<?php include __DIR__ . '/partials/sidebar.php'; ?>

<div class="topbar mb-4">
  <div class="d-flex align-items-center gap-3">
    <button class="btn btn-outline-primary d-md-none"
            data-bs-toggle="offcanvas"
            data-bs-target="#sidebarAdmin">
      <i class="bi bi-list"></i>
    </button>

    <div>
      <div class="fw-semibold">Approval Izin / Cuti</div>
      <small class="text-muted">Tutor</small>
    </div>
  </div>

  <div class="text-end">
    <div class="fw-semibold">Admin</div>
    <small class="text-muted">PKBM</small>
  </div>
</div>



<div class="container-fluid" style="margin-left:260px">

  <div class="py-3">
    <h4 class="fw-bold mb-3"><i class="bi bi-clipboard-check"></i> Approval Izin/Cuti Tutor</h4>

    <div class="card shadow-sm">
      <div class="card-body p-0">

        <div class="table-responsive">
          <table class="table table-bordered table-striped table-sm mb-0">
          <thead class="table-dark">
            <tr>
              <th style="width:180px">Tutor</th>
              <th>Jenis</th>
              <th>Mulai</th>
              <th>Selesai</th>
              <th>Alasan</th>
              <th>Lampiran</th>
              <th>Status</th>
              <th style="width:160px">Aksi</th>
            </tr>
          </thead>
          <tbody>
          <?php while($r=mysqli_fetch_assoc($q)): ?>

<?php
$status = $r['status_approval'];

if ($status == 'approved') {
    $pesan = "Halo {$r['nama']}, izin/cuti Anda TELAH DISETUJUI. Silakan menyesuaikan jadwal. Terima kasih.";
} elseif ($status == 'rejected') {
    $pesan = "Halo {$r['nama']}, mohon maaf izin/cuti Anda DITOLAK. Silakan hubungi admin untuk info lebih lanjut.";
} else {
    $pesan = "Halo {$r['nama']}, izin/cuti Anda sedang DIPROSES. Mohon menunggu konfirmasi.";
}

$link_wa = "https://wa.me/" . preg_replace('/\D/','',$r['no_hp']) .
           "?text=" . urlencode($pesan);
?>

<tr>
  <td>
    <strong><?= $r['nama'] ?></strong><br>
    <small><?= $r['no_hp'] ?></small><br>

    <?php if($r['no_hp']): ?>
      <a href="<?= $link_wa ?>" target="_blank" class="text-success">
        <i class="bi bi-whatsapp"></i> WhatsApp
      </a>
    <?php endif; ?>
  </td>

  <td><?= strtoupper($r['jenis']) ?></td>
  <td><?= $r['tanggal_mulai'] ?></td>
  <td><?= $r['tanggal_selesai'] ?></td>
  <td><?= $r['alasan'] ?></td>

  <td>
    <?php if($r['lampiran']): ?>
      <a href="../presensi/uploads/izin/<?= $r['lampiran'] ?>" target="_blank">📎 Lihat</a>
    <?php else: ?>-
    <?php endif; ?>
  </td>

  <td>
    <span class="badge <?= $r['status_approval'] ?>">
      <?= strtoupper($r['status_approval']) ?>
    </span>
  </td>

  <td>
    <?php if($status=='pending'): ?>
      <a href="izin_cuti_action.php?id=<?= $r['id'] ?>&act=approve"
         class="btn btn-success btn-sm">
         <i class="bi bi-check2"></i> Approve
      </a>
      <a href="izin_cuti_action.php?id=<?= $r['id'] ?>&act=reject"
         class="btn btn-danger btn-sm">
         <i class="bi bi-x"></i> Reject
      </a>
    <?php else: ?>
      <span class="text-secondary fst-italic small">Sudah diproses</span>
    <?php endif; ?>
  </td>
</tr>

<?php endwhile; ?>

          </tbody>
        </table>

      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
