<?php
session_start();
require '../config/database.php';

if (!isset($_SESSION['login']) || $_SESSION['user']['role'] !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

/* =====================
   TAMBAH / EDIT
===================== */
if (isset($_POST['simpan'])) {

    $judul     = mysqli_real_escape_string($conn, $_POST['judul']);
    $kategori  = $_POST['kategori'];
    $jenis     = $_POST['jenis'];
    $deskripsi = mysqli_real_escape_string($conn, $_POST['deskripsi']);

    // Folder otomatis: pkbm-test/ebook_file/pdf|word|video
    $folder = __DIR__ . "/ebook_file/$jenis";
    if (!is_dir($folder)) mkdir($folder, 0777, true);

    if ($_POST['aksi'] === 'tambah') {

        if (isset($_FILES['file']) && $_FILES['file']['error'] === UPLOAD_ERR_OK) {
            $ext  = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
            $file = time() . '_' . rand(100, 999) . '.' . $ext;
            $target = "$folder/$file";

            if (!move_uploaded_file($_FILES['file']['tmp_name'], $target)) {
                die("Gagal memindahkan file ke folder $target");
            }

            // Simpan ke database
            mysqli_query($conn, "INSERT INTO ebook 
                (judul,kategori,jenis,file,deskripsi)
                VALUES ('$judul','$kategori','$jenis','$file','$deskripsi')");

        } else {
            die("File tidak di-upload atau terjadi error: " . ($_FILES['file']['error'] ?? 'Tidak ada file'));
        }

    } else { // EDIT

        $id = (int)$_POST['id'];
        $qfile = '';

        if (!empty($_FILES['file']['name'])) {
            if ($_FILES['file']['error'] === UPLOAD_ERR_OK) {
                $ext  = pathinfo($_FILES['file']['name'], PATHINFO_EXTENSION);
                $file = time() . '_' . rand(100, 999) . '.' . $ext;
                $target = "$folder/$file";

                if (!move_uploaded_file($_FILES['file']['tmp_name'], $target)) {
                    die("Gagal memindahkan file saat edit ke folder $target");
                }

                $qfile = ", file='$file'";
            } else {
                die("File tidak di-upload atau terjadi error saat edit: " . $_FILES['file']['error']);
            }
        }

        // Update database
        mysqli_query($conn, "UPDATE ebook SET
            judul='$judul',
            kategori='$kategori',
            jenis='$jenis',
            deskripsi='$deskripsi'
            $qfile
            WHERE id='$id'");
    }

    header("Location: ebook.php");
    exit;
}

/* =====================
   HAPUS
===================== */
if (isset($_GET['hapus'])) {
    $id = (int)$_GET['hapus'];
    $q  = mysqli_query($conn, "SELECT * FROM ebook WHERE id='$id'");
    $d  = mysqli_fetch_assoc($q);

    if ($d) {
        $file = __DIR__ . "/ebook_file/{$d['jenis']}/{$d['file']}";
        if (file_exists($file)) unlink($file);
    }

    mysqli_query($conn, "DELETE FROM ebook WHERE id='$id'");
    header("Location: ebook.php");
    exit;
}

$data = mysqli_query($conn, "SELECT * FROM ebook ORDER BY id DESC");
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Manajemen E-Book</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<style>
body { background:#f5f7fa; margin:0; padding-top:45px; }
.sidebar{ width:260px; position:fixed; top:0; left:0; height:100vh; z-index:1030; background:#fff; border-right:1px solid #ddd; }
.topbar{ position:fixed; top:0; left:260px; right:0; height:56px; background:#fff; border-bottom:1px solid #ddd; display:flex; align-items:center; justify-content:space-between; padding:0 16px; z-index:1020; }
.topbar .btn-add{ margin-left:auto; }
.main-content{ margin-left:260px; padding-top:70px; transition:.3s; }
@media(max-width:991px){
    .sidebar{ position:fixed; width:250px; height:100vh; transform:translateX(-100%); transition:transform .3s; z-index:1040; }
    .sidebar.show{ transform:translateX(0); }
    .topbar{ left:0; justify-content:flex-start; gap:10px; }
    .main-content{ margin-left:0; padding-top:70px; }
}
.table td, .table th{ vertical-align:middle; }
.badge{ font-size:.8rem; }
footer{ margin-top:20px; }
.topbar button.btn-primary{ margin-top:8px; }
@media(min-width:768px){ .topbar button.btn-primary{ margin-top:0; } }
</style>
</head>
<body>
<?php include __DIR__ . '/partials/sidebar.php'; ?>

<div class="topbar">
    <button class="btn btn-outline-primary d-lg-none" data-bs-toggle="offcanvas" data-bs-target="#sidebarAdmin">
        <i class="bi bi-list"></i>
    </button>
    <span class="fw-semibold ms-2">Manajemen E-Book</span>
</div>

<div class="main-content p-3 p-md-4">
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3 gap-2">
        <h4 class="fw-bold mb-0">📘 Manajemen E-Book</h4>
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalForm" onclick="resetForm()">
            <i class="bi bi-plus"></i> Tambah
        </button>
    </div>

<div class="card shadow-sm border-0">
<div class="card-body table-responsive">
<table class="table table-hover align-middle">
<thead class="table-dark text-center">
<tr>
<th width="40">No</th>
<th>Judul</th>
<th>Kategori</th>
<th>Jenis</th>
<th>File</th>
<th width="120">Aksi</th>
</tr>
</thead>
<tbody>

<?php $no=1; while($r=mysqli_fetch_assoc($data)): ?>
<tr>
<td class="text-center"><?= $no++ ?></td>
<td><?= htmlspecialchars($r['judul']) ?></td>
<td class="text-center">
<span class="badge bg-<?= $r['kategori']=='guru'?'primary':'success' ?>"><?= ucfirst($r['kategori']) ?></span>
</td>
<td class="text-center">
<span class="badge bg-info text-dark"><?= strtoupper($r['jenis']) ?></span>
</td>
<td class="text-center">
<a href="ebook_file/<?= $r['jenis'] ?>/<?= $r['file'] ?>" target="_blank" class="btn btn-success btn-sm">
<i class="bi bi-eye"></i>
</a>
</td>
<td class="text-center">
<button class="btn btn-warning btn-sm" onclick='editData(<?= json_encode($r) ?>)' data-bs-toggle="modal" data-bs-target="#modalForm">
<i class="bi bi-pencil"></i></button>
<a href="?hapus=<?= $r['id'] ?>" onclick="return confirm('Hapus E-Book?')" class="btn btn-danger btn-sm">
<i class="bi bi-trash"></i></a>
</td>
</tr>
<?php endwhile ?>

</tbody>
</table>
</div>
</div>
</div>

<div class="modal fade" id="modalForm">
<div class="modal-dialog modal-dialog-centered">
<form method="post" enctype="multipart/form-data">
<div class="modal-content">
<div class="modal-header">
<h5 id="modalTitle">Tambah E-Book</h5>
<button class="btn-close" data-bs-dismiss="modal"></button>
</div>

<div class="modal-body">
<input type="hidden" name="id" id="id">
<input type="hidden" name="aksi" id="aksi" value="tambah">

<input class="form-control mb-2" name="judul" id="judul" placeholder="Judul" required>
<select name="kategori" id="kategori" class="form-control mb-2" required>
<option value="">-- Kategori --</option>
<option value="guru">Guru</option>
<option value="murid">Murid</option>
</select>
<select name="jenis" id="jenis" class="form-control mb-2" required>
<option value="">-- Jenis --</option>
<option value="pdf">PDF</option>
<option value="video">Video</option>
<option value="word">Word</option>
</select>
<textarea name="deskripsi" id="deskripsi" class="form-control mb-2" placeholder="Deskripsi"></textarea>
<input type="file" name="file" class="form-control">
<small class="text-muted">Kosongkan saat edit jika tidak diganti</small>
</div>

<div class="modal-footer">
<button class="btn btn-primary" name="simpan">Simpan</button>
</div>
</div>
</form>
</div>
</div>

<script>
function resetForm(){
 document.getElementById('modalTitle').innerText='Tambah E-Book';
 document.getElementById('aksi').value='tambah';
 document.querySelector('form').reset();
}

function editData(d){
 document.getElementById('modalTitle').innerText='Edit E-Book';
 document.getElementById('aksi').value='edit';
 document.getElementById('id').value=d.id;
 document.getElementById('judul').value=d.judul;
 document.getElementById('kategori').value=d.kategori;
 document.getElementById('jenis').value=d.jenis;
 document.getElementById('deskripsi').value=d.deskripsi;
}
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
